
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "APIService",
    "APIServiceList",
    "BaseKubernetesList",
    "Binding",
    "ComponentStatus",
    "ComponentStatusList",
    "Config",
    "ConfigMap",
    "ConfigMapList",
    "ContainerStatus",
    "CreateOptions",
    "DeleteOptions",
    "EndpointPort",
    "Endpoints",
    "EndpointsList",
    "EnvVar",
    "Event",
    "EventList",
    "EventSeries",
    "EventSource",
    "GetOptions",
    "GroupVersionKind",
    "GroupVersionResource",
    "Info",
    "LimitRangeList",
    "ListOptions",
    "MicroTime",
    "Namespace",
    "NamespaceList",
    "Node",
    "NodeList",
    "ObjectMeta",
    "Patch",
    "PatchOptions",
    "PersistentVolume",
    "PersistentVolumeClaim",
    "PersistentVolumeClaimList",
    "PersistentVolumeList",
    "PodExecOptions",
    "PodList",
    "PodTemplateList",
    "Quantity",
    "ReplicationControllerList",
    "ResourceQuota",
    "ResourceQuotaList",
    "RootPaths",
    "Secret",
    "SecretList",
    "ServiceAccount",
    "ServiceAccountList",
    "ServiceList",
    "Status",
    "Time",
    "Toleration",
    "TopologySelectorTerm",
    "TypeMeta",
    "UpdateOptions",
    "WatchEvent"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = true, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("APIService")
    private APIService aPIService;
    /**
     * 
     * 
     */
    @JsonProperty("APIServiceList")
    private APIServiceList aPIServiceList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("Binding")
    private Binding binding;
    /**
     * 
     * 
     */
    @JsonProperty("ComponentStatus")
    private ComponentStatus componentStatus;
    /**
     * 
     * 
     */
    @JsonProperty("ComponentStatusList")
    private ComponentStatusList componentStatusList;
    /**
     * 
     * 
     */
    @JsonProperty("Config")
    private Config config;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMap")
    private ConfigMap configMap;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMapList")
    private ConfigMapList configMapList;
    /**
     * 
     * 
     */
    @JsonProperty("ContainerStatus")
    private ContainerStatus containerStatus;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("EndpointPort")
    private EndpointPort endpointPort;
    /**
     * 
     * 
     */
    @JsonProperty("Endpoints")
    private Endpoints endpoints;
    /**
     * 
     * 
     */
    @JsonProperty("EndpointsList")
    private EndpointsList endpointsList;
    /**
     * 
     * 
     */
    @JsonProperty("EnvVar")
    private EnvVar envVar;
    /**
     * 
     * 
     */
    @JsonProperty("Event")
    private Event event;
    /**
     * 
     * 
     */
    @JsonProperty("EventList")
    private EventList eventList;
    /**
     * 
     * 
     */
    @JsonProperty("EventSeries")
    private EventSeries eventSeries;
    /**
     * 
     * 
     */
    @JsonProperty("EventSource")
    private EventSource eventSource;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("GroupVersionKind")
    private GroupVersionKind groupVersionKind;
    /**
     * 
     * 
     */
    @JsonProperty("GroupVersionResource")
    private GroupVersionResource groupVersionResource;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("LimitRangeList")
    private LimitRangeList limitRangeList;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("MicroTime")
    private MicroTime microTime;
    /**
     * 
     * 
     */
    @JsonProperty("Namespace")
    private Namespace namespace;
    /**
     * 
     * 
     */
    @JsonProperty("NamespaceList")
    private NamespaceList namespaceList;
    /**
     * 
     * 
     */
    @JsonProperty("Node")
    private Node node;
    /**
     * 
     * 
     */
    @JsonProperty("NodeList")
    private NodeList nodeList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolume")
    private PersistentVolume persistentVolume;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeClaim")
    private PersistentVolumeClaim persistentVolumeClaim;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeClaimList")
    private PersistentVolumeClaimList persistentVolumeClaimList;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeList")
    private PersistentVolumeList persistentVolumeList;
    /**
     * 
     * 
     */
    @JsonProperty("PodExecOptions")
    private PodExecOptions podExecOptions;
    /**
     * 
     * 
     */
    @JsonProperty("PodList")
    private PodList podList;
    /**
     * 
     * 
     */
    @JsonProperty("PodTemplateList")
    private PodTemplateList podTemplateList;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicationControllerList")
    private ReplicationControllerList replicationControllerList;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceQuota")
    private ResourceQuota resourceQuota;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceQuotaList")
    private ResourceQuotaList resourceQuotaList;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Secret")
    private Secret secret;
    /**
     * 
     * 
     */
    @JsonProperty("SecretList")
    private SecretList secretList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceAccount")
    private ServiceAccount serviceAccount;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceAccountList")
    private ServiceAccountList serviceAccountList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceList")
    private ServiceList serviceList;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("Toleration")
    private Toleration toleration;
    /**
     * 
     * 
     */
    @JsonProperty("TopologySelectorTerm")
    private TopologySelectorTerm topologySelectorTerm;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    /**
     * 
     * 
     */
    @JsonProperty("WatchEvent")
    private WatchEvent watchEvent;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param configMapList
     * @param eventList
     * @param binding
     * @param namespaceList
     * @param patch
     * @param serviceAccountList
     * @param persistentVolume
     * @param resourceQuota
     * @param watchEvent
     * @param secretList
     * @param info
     * @param deleteOptions
     * @param groupVersionResource
     * @param limitRangeList
     * @param toleration
     * @param nodeList
     * @param groupVersionKind
     * @param node
     * @param configMap
     * @param getOptions
     * @param eventSeries
     * @param persistentVolumeClaimList
     * @param status
     * @param replicationControllerList
     * @param eventSource
     * @param baseKubernetesList
     * @param updateOptions
     * @param componentStatus
     * @param podList
     * @param secret
     * @param aPIService
     * @param persistentVolumeList
     * @param rootPaths
     * @param event
     * @param containerStatus
     * @param aPIServiceList
     * @param endpointsList
     * @param patchOptions
     * @param endpoints
     * @param quantity
     * @param envVar
     * @param microTime
     * @param podExecOptions
     * @param serviceAccount
     * @param resourceQuotaList
     * @param topologySelectorTerm
     * @param createOptions
     * @param podTemplateList
     * @param aPIGroup
     * @param typeMeta
     * @param objectMeta
     * @param namespace
     * @param serviceList
     * @param componentStatusList
     * @param persistentVolumeClaim
     * @param time
     * @param endpointPort
     * @param config
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, APIService aPIService, APIServiceList aPIServiceList, BaseKubernetesList baseKubernetesList, Binding binding, ComponentStatus componentStatus, ComponentStatusList componentStatusList, Config config, ConfigMap configMap, ConfigMapList configMapList, ContainerStatus containerStatus, CreateOptions createOptions, DeleteOptions deleteOptions, EndpointPort endpointPort, Endpoints endpoints, EndpointsList endpointsList, EnvVar envVar, Event event, EventList eventList, EventSeries eventSeries, EventSource eventSource, GetOptions getOptions, GroupVersionKind groupVersionKind, GroupVersionResource groupVersionResource, Info info, LimitRangeList limitRangeList, ListOptions listOptions, MicroTime microTime, Namespace namespace, NamespaceList namespaceList, Node node, NodeList nodeList, ObjectMeta objectMeta, Patch patch, PatchOptions patchOptions, PersistentVolume persistentVolume, PersistentVolumeClaim persistentVolumeClaim, PersistentVolumeClaimList persistentVolumeClaimList, PersistentVolumeList persistentVolumeList, PodExecOptions podExecOptions, PodList podList, PodTemplateList podTemplateList, Quantity quantity, ReplicationControllerList replicationControllerList, ResourceQuota resourceQuota, ResourceQuotaList resourceQuotaList, RootPaths rootPaths, Secret secret, SecretList secretList, ServiceAccount serviceAccount, ServiceAccountList serviceAccountList, ServiceList serviceList, Status status, String time, Toleration toleration, TopologySelectorTerm topologySelectorTerm, TypeMeta typeMeta, UpdateOptions updateOptions, WatchEvent watchEvent) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.aPIService = aPIService;
        this.aPIServiceList = aPIServiceList;
        this.baseKubernetesList = baseKubernetesList;
        this.binding = binding;
        this.componentStatus = componentStatus;
        this.componentStatusList = componentStatusList;
        this.config = config;
        this.configMap = configMap;
        this.configMapList = configMapList;
        this.containerStatus = containerStatus;
        this.createOptions = createOptions;
        this.deleteOptions = deleteOptions;
        this.endpointPort = endpointPort;
        this.endpoints = endpoints;
        this.endpointsList = endpointsList;
        this.envVar = envVar;
        this.event = event;
        this.eventList = eventList;
        this.eventSeries = eventSeries;
        this.eventSource = eventSource;
        this.getOptions = getOptions;
        this.groupVersionKind = groupVersionKind;
        this.groupVersionResource = groupVersionResource;
        this.info = info;
        this.limitRangeList = limitRangeList;
        this.listOptions = listOptions;
        this.microTime = microTime;
        this.namespace = namespace;
        this.namespaceList = namespaceList;
        this.node = node;
        this.nodeList = nodeList;
        this.objectMeta = objectMeta;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.persistentVolume = persistentVolume;
        this.persistentVolumeClaim = persistentVolumeClaim;
        this.persistentVolumeClaimList = persistentVolumeClaimList;
        this.persistentVolumeList = persistentVolumeList;
        this.podExecOptions = podExecOptions;
        this.podList = podList;
        this.podTemplateList = podTemplateList;
        this.quantity = quantity;
        this.replicationControllerList = replicationControllerList;
        this.resourceQuota = resourceQuota;
        this.resourceQuotaList = resourceQuotaList;
        this.rootPaths = rootPaths;
        this.secret = secret;
        this.secretList = secretList;
        this.serviceAccount = serviceAccount;
        this.serviceAccountList = serviceAccountList;
        this.serviceList = serviceList;
        this.status = status;
        this.time = time;
        this.toleration = toleration;
        this.topologySelectorTerm = topologySelectorTerm;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
        this.watchEvent = watchEvent;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The aPIService
     */
    @JsonProperty("APIService")
    public APIService getAPIService() {
        return aPIService;
    }

    /**
     * 
     * 
     * @param aPIService
     *     The APIService
     */
    @JsonProperty("APIService")
    public void setAPIService(APIService aPIService) {
        this.aPIService = aPIService;
    }

    /**
     * 
     * 
     * @return
     *     The aPIServiceList
     */
    @JsonProperty("APIServiceList")
    public APIServiceList getAPIServiceList() {
        return aPIServiceList;
    }

    /**
     * 
     * 
     * @param aPIServiceList
     *     The APIServiceList
     */
    @JsonProperty("APIServiceList")
    public void setAPIServiceList(APIServiceList aPIServiceList) {
        this.aPIServiceList = aPIServiceList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The binding
     */
    @JsonProperty("Binding")
    public Binding getBinding() {
        return binding;
    }

    /**
     * 
     * 
     * @param binding
     *     The Binding
     */
    @JsonProperty("Binding")
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    /**
     * 
     * 
     * @return
     *     The componentStatus
     */
    @JsonProperty("ComponentStatus")
    public ComponentStatus getComponentStatus() {
        return componentStatus;
    }

    /**
     * 
     * 
     * @param componentStatus
     *     The ComponentStatus
     */
    @JsonProperty("ComponentStatus")
    public void setComponentStatus(ComponentStatus componentStatus) {
        this.componentStatus = componentStatus;
    }

    /**
     * 
     * 
     * @return
     *     The componentStatusList
     */
    @JsonProperty("ComponentStatusList")
    public ComponentStatusList getComponentStatusList() {
        return componentStatusList;
    }

    /**
     * 
     * 
     * @param componentStatusList
     *     The ComponentStatusList
     */
    @JsonProperty("ComponentStatusList")
    public void setComponentStatusList(ComponentStatusList componentStatusList) {
        this.componentStatusList = componentStatusList;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("Config")
    public Config getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The Config
     */
    @JsonProperty("Config")
    public void setConfig(Config config) {
        this.config = config;
    }

    /**
     * 
     * 
     * @return
     *     The configMap
     */
    @JsonProperty("ConfigMap")
    public ConfigMap getConfigMap() {
        return configMap;
    }

    /**
     * 
     * 
     * @param configMap
     *     The ConfigMap
     */
    @JsonProperty("ConfigMap")
    public void setConfigMap(ConfigMap configMap) {
        this.configMap = configMap;
    }

    /**
     * 
     * 
     * @return
     *     The configMapList
     */
    @JsonProperty("ConfigMapList")
    public ConfigMapList getConfigMapList() {
        return configMapList;
    }

    /**
     * 
     * 
     * @param configMapList
     *     The ConfigMapList
     */
    @JsonProperty("ConfigMapList")
    public void setConfigMapList(ConfigMapList configMapList) {
        this.configMapList = configMapList;
    }

    /**
     * 
     * 
     * @return
     *     The containerStatus
     */
    @JsonProperty("ContainerStatus")
    public ContainerStatus getContainerStatus() {
        return containerStatus;
    }

    /**
     * 
     * 
     * @param containerStatus
     *     The ContainerStatus
     */
    @JsonProperty("ContainerStatus")
    public void setContainerStatus(ContainerStatus containerStatus) {
        this.containerStatus = containerStatus;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The endpointPort
     */
    @JsonProperty("EndpointPort")
    public EndpointPort getEndpointPort() {
        return endpointPort;
    }

    /**
     * 
     * 
     * @param endpointPort
     *     The EndpointPort
     */
    @JsonProperty("EndpointPort")
    public void setEndpointPort(EndpointPort endpointPort) {
        this.endpointPort = endpointPort;
    }

    /**
     * 
     * 
     * @return
     *     The endpoints
     */
    @JsonProperty("Endpoints")
    public Endpoints getEndpoints() {
        return endpoints;
    }

    /**
     * 
     * 
     * @param endpoints
     *     The Endpoints
     */
    @JsonProperty("Endpoints")
    public void setEndpoints(Endpoints endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * 
     * 
     * @return
     *     The endpointsList
     */
    @JsonProperty("EndpointsList")
    public EndpointsList getEndpointsList() {
        return endpointsList;
    }

    /**
     * 
     * 
     * @param endpointsList
     *     The EndpointsList
     */
    @JsonProperty("EndpointsList")
    public void setEndpointsList(EndpointsList endpointsList) {
        this.endpointsList = endpointsList;
    }

    /**
     * 
     * 
     * @return
     *     The envVar
     */
    @JsonProperty("EnvVar")
    public EnvVar getEnvVar() {
        return envVar;
    }

    /**
     * 
     * 
     * @param envVar
     *     The EnvVar
     */
    @JsonProperty("EnvVar")
    public void setEnvVar(EnvVar envVar) {
        this.envVar = envVar;
    }

    /**
     * 
     * 
     * @return
     *     The event
     */
    @JsonProperty("Event")
    public Event getEvent() {
        return event;
    }

    /**
     * 
     * 
     * @param event
     *     The Event
     */
    @JsonProperty("Event")
    public void setEvent(Event event) {
        this.event = event;
    }

    /**
     * 
     * 
     * @return
     *     The eventList
     */
    @JsonProperty("EventList")
    public EventList getEventList() {
        return eventList;
    }

    /**
     * 
     * 
     * @param eventList
     *     The EventList
     */
    @JsonProperty("EventList")
    public void setEventList(EventList eventList) {
        this.eventList = eventList;
    }

    /**
     * 
     * 
     * @return
     *     The eventSeries
     */
    @JsonProperty("EventSeries")
    public EventSeries getEventSeries() {
        return eventSeries;
    }

    /**
     * 
     * 
     * @param eventSeries
     *     The EventSeries
     */
    @JsonProperty("EventSeries")
    public void setEventSeries(EventSeries eventSeries) {
        this.eventSeries = eventSeries;
    }

    /**
     * 
     * 
     * @return
     *     The eventSource
     */
    @JsonProperty("EventSource")
    public EventSource getEventSource() {
        return eventSource;
    }

    /**
     * 
     * 
     * @param eventSource
     *     The EventSource
     */
    @JsonProperty("EventSource")
    public void setEventSource(EventSource eventSource) {
        this.eventSource = eventSource;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The groupVersionKind
     */
    @JsonProperty("GroupVersionKind")
    public GroupVersionKind getGroupVersionKind() {
        return groupVersionKind;
    }

    /**
     * 
     * 
     * @param groupVersionKind
     *     The GroupVersionKind
     */
    @JsonProperty("GroupVersionKind")
    public void setGroupVersionKind(GroupVersionKind groupVersionKind) {
        this.groupVersionKind = groupVersionKind;
    }

    /**
     * 
     * 
     * @return
     *     The groupVersionResource
     */
    @JsonProperty("GroupVersionResource")
    public GroupVersionResource getGroupVersionResource() {
        return groupVersionResource;
    }

    /**
     * 
     * 
     * @param groupVersionResource
     *     The GroupVersionResource
     */
    @JsonProperty("GroupVersionResource")
    public void setGroupVersionResource(GroupVersionResource groupVersionResource) {
        this.groupVersionResource = groupVersionResource;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The limitRangeList
     */
    @JsonProperty("LimitRangeList")
    public LimitRangeList getLimitRangeList() {
        return limitRangeList;
    }

    /**
     * 
     * 
     * @param limitRangeList
     *     The LimitRangeList
     */
    @JsonProperty("LimitRangeList")
    public void setLimitRangeList(LimitRangeList limitRangeList) {
        this.limitRangeList = limitRangeList;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The microTime
     */
    @JsonProperty("MicroTime")
    public MicroTime getMicroTime() {
        return microTime;
    }

    /**
     * 
     * 
     * @param microTime
     *     The MicroTime
     */
    @JsonProperty("MicroTime")
    public void setMicroTime(MicroTime microTime) {
        this.microTime = microTime;
    }

    /**
     * 
     * 
     * @return
     *     The namespace
     */
    @JsonProperty("Namespace")
    public Namespace getNamespace() {
        return namespace;
    }

    /**
     * 
     * 
     * @param namespace
     *     The Namespace
     */
    @JsonProperty("Namespace")
    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    /**
     * 
     * 
     * @return
     *     The namespaceList
     */
    @JsonProperty("NamespaceList")
    public NamespaceList getNamespaceList() {
        return namespaceList;
    }

    /**
     * 
     * 
     * @param namespaceList
     *     The NamespaceList
     */
    @JsonProperty("NamespaceList")
    public void setNamespaceList(NamespaceList namespaceList) {
        this.namespaceList = namespaceList;
    }

    /**
     * 
     * 
     * @return
     *     The node
     */
    @JsonProperty("Node")
    public Node getNode() {
        return node;
    }

    /**
     * 
     * 
     * @param node
     *     The Node
     */
    @JsonProperty("Node")
    public void setNode(Node node) {
        this.node = node;
    }

    /**
     * 
     * 
     * @return
     *     The nodeList
     */
    @JsonProperty("NodeList")
    public NodeList getNodeList() {
        return nodeList;
    }

    /**
     * 
     * 
     * @param nodeList
     *     The NodeList
     */
    @JsonProperty("NodeList")
    public void setNodeList(NodeList nodeList) {
        this.nodeList = nodeList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolume
     */
    @JsonProperty("PersistentVolume")
    public PersistentVolume getPersistentVolume() {
        return persistentVolume;
    }

    /**
     * 
     * 
     * @param persistentVolume
     *     The PersistentVolume
     */
    @JsonProperty("PersistentVolume")
    public void setPersistentVolume(PersistentVolume persistentVolume) {
        this.persistentVolume = persistentVolume;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeClaim
     */
    @JsonProperty("PersistentVolumeClaim")
    public PersistentVolumeClaim getPersistentVolumeClaim() {
        return persistentVolumeClaim;
    }

    /**
     * 
     * 
     * @param persistentVolumeClaim
     *     The PersistentVolumeClaim
     */
    @JsonProperty("PersistentVolumeClaim")
    public void setPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeClaimList
     */
    @JsonProperty("PersistentVolumeClaimList")
    public PersistentVolumeClaimList getPersistentVolumeClaimList() {
        return persistentVolumeClaimList;
    }

    /**
     * 
     * 
     * @param persistentVolumeClaimList
     *     The PersistentVolumeClaimList
     */
    @JsonProperty("PersistentVolumeClaimList")
    public void setPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
        this.persistentVolumeClaimList = persistentVolumeClaimList;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeList
     */
    @JsonProperty("PersistentVolumeList")
    public PersistentVolumeList getPersistentVolumeList() {
        return persistentVolumeList;
    }

    /**
     * 
     * 
     * @param persistentVolumeList
     *     The PersistentVolumeList
     */
    @JsonProperty("PersistentVolumeList")
    public void setPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
        this.persistentVolumeList = persistentVolumeList;
    }

    /**
     * 
     * 
     * @return
     *     The podExecOptions
     */
    @JsonProperty("PodExecOptions")
    public PodExecOptions getPodExecOptions() {
        return podExecOptions;
    }

    /**
     * 
     * 
     * @param podExecOptions
     *     The PodExecOptions
     */
    @JsonProperty("PodExecOptions")
    public void setPodExecOptions(PodExecOptions podExecOptions) {
        this.podExecOptions = podExecOptions;
    }

    /**
     * 
     * 
     * @return
     *     The podList
     */
    @JsonProperty("PodList")
    public PodList getPodList() {
        return podList;
    }

    /**
     * 
     * 
     * @param podList
     *     The PodList
     */
    @JsonProperty("PodList")
    public void setPodList(PodList podList) {
        this.podList = podList;
    }

    /**
     * 
     * 
     * @return
     *     The podTemplateList
     */
    @JsonProperty("PodTemplateList")
    public PodTemplateList getPodTemplateList() {
        return podTemplateList;
    }

    /**
     * 
     * 
     * @param podTemplateList
     *     The PodTemplateList
     */
    @JsonProperty("PodTemplateList")
    public void setPodTemplateList(PodTemplateList podTemplateList) {
        this.podTemplateList = podTemplateList;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The replicationControllerList
     */
    @JsonProperty("ReplicationControllerList")
    public ReplicationControllerList getReplicationControllerList() {
        return replicationControllerList;
    }

    /**
     * 
     * 
     * @param replicationControllerList
     *     The ReplicationControllerList
     */
    @JsonProperty("ReplicationControllerList")
    public void setReplicationControllerList(ReplicationControllerList replicationControllerList) {
        this.replicationControllerList = replicationControllerList;
    }

    /**
     * 
     * 
     * @return
     *     The resourceQuota
     */
    @JsonProperty("ResourceQuota")
    public ResourceQuota getResourceQuota() {
        return resourceQuota;
    }

    /**
     * 
     * 
     * @param resourceQuota
     *     The ResourceQuota
     */
    @JsonProperty("ResourceQuota")
    public void setResourceQuota(ResourceQuota resourceQuota) {
        this.resourceQuota = resourceQuota;
    }

    /**
     * 
     * 
     * @return
     *     The resourceQuotaList
     */
    @JsonProperty("ResourceQuotaList")
    public ResourceQuotaList getResourceQuotaList() {
        return resourceQuotaList;
    }

    /**
     * 
     * 
     * @param resourceQuotaList
     *     The ResourceQuotaList
     */
    @JsonProperty("ResourceQuotaList")
    public void setResourceQuotaList(ResourceQuotaList resourceQuotaList) {
        this.resourceQuotaList = resourceQuotaList;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The secret
     */
    @JsonProperty("Secret")
    public Secret getSecret() {
        return secret;
    }

    /**
     * 
     * 
     * @param secret
     *     The Secret
     */
    @JsonProperty("Secret")
    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    /**
     * 
     * 
     * @return
     *     The secretList
     */
    @JsonProperty("SecretList")
    public SecretList getSecretList() {
        return secretList;
    }

    /**
     * 
     * 
     * @param secretList
     *     The SecretList
     */
    @JsonProperty("SecretList")
    public void setSecretList(SecretList secretList) {
        this.secretList = secretList;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccount
     */
    @JsonProperty("ServiceAccount")
    public ServiceAccount getServiceAccount() {
        return serviceAccount;
    }

    /**
     * 
     * 
     * @param serviceAccount
     *     The ServiceAccount
     */
    @JsonProperty("ServiceAccount")
    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountList
     */
    @JsonProperty("ServiceAccountList")
    public ServiceAccountList getServiceAccountList() {
        return serviceAccountList;
    }

    /**
     * 
     * 
     * @param serviceAccountList
     *     The ServiceAccountList
     */
    @JsonProperty("ServiceAccountList")
    public void setServiceAccountList(ServiceAccountList serviceAccountList) {
        this.serviceAccountList = serviceAccountList;
    }

    /**
     * 
     * 
     * @return
     *     The serviceList
     */
    @JsonProperty("ServiceList")
    public ServiceList getServiceList() {
        return serviceList;
    }

    /**
     * 
     * 
     * @param serviceList
     *     The ServiceList
     */
    @JsonProperty("ServiceList")
    public void setServiceList(ServiceList serviceList) {
        this.serviceList = serviceList;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The toleration
     */
    @JsonProperty("Toleration")
    public Toleration getToleration() {
        return toleration;
    }

    /**
     * 
     * 
     * @param toleration
     *     The Toleration
     */
    @JsonProperty("Toleration")
    public void setToleration(Toleration toleration) {
        this.toleration = toleration;
    }

    /**
     * 
     * 
     * @return
     *     The topologySelectorTerm
     */
    @JsonProperty("TopologySelectorTerm")
    public TopologySelectorTerm getTopologySelectorTerm() {
        return topologySelectorTerm;
    }

    /**
     * 
     * 
     * @param topologySelectorTerm
     *     The TopologySelectorTerm
     */
    @JsonProperty("TopologySelectorTerm")
    public void setTopologySelectorTerm(TopologySelectorTerm topologySelectorTerm) {
        this.topologySelectorTerm = topologySelectorTerm;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The watchEvent
     */
    @JsonProperty("WatchEvent")
    public WatchEvent getWatchEvent() {
        return watchEvent;
    }

    /**
     * 
     * 
     * @param watchEvent
     *     The WatchEvent
     */
    @JsonProperty("WatchEvent")
    public void setWatchEvent(WatchEvent watchEvent) {
        this.watchEvent = watchEvent;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
