/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.StatusCause;
import io.fabric8.kubernetes.api.model.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.StatusCauseFluentImpl;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StatusDetailsFluentImpl<A extends StatusDetailsFluent<A>>
extends BaseFluent<A>
implements StatusDetailsFluent<A> {
    private List<StatusCauseBuilder> causes = new ArrayList<StatusCauseBuilder>();
    private String group;
    private String kind;
    private String name;
    private Integer retryAfterSeconds;
    private String uid;

    public StatusDetailsFluentImpl() {
    }

    public StatusDetailsFluentImpl(StatusDetails instance) {
        this.withCauses(instance.getCauses());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToCauses(int index, StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        this._visitables.get("causes").add(index >= 0 ? index : this._visitables.get("causes").size(), builder);
        this.causes.add(index >= 0 ? index : this.causes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCauses(int index, StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        if (index < 0 || index >= this._visitables.get("causes").size()) {
            this._visitables.get("causes").add(builder);
        } else {
            this._visitables.get("causes").set(index, builder);
        }
        if (index < 0 || index >= this.causes.size()) {
            this.causes.add(builder);
        } else {
            this.causes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCauses(StatusCause ... items) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCauses(Collection<StatusCause> items) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCauses(StatusCause ... items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCauses(Collection<StatusCause> items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCauses(Predicate<StatusCauseBuilder> predicate) {
        if (this.causes == null) {
            return (A)this;
        }
        Iterator<StatusCauseBuilder> each = this.causes.iterator();
        Object visitables = this._visitables.get("causes");
        while (each.hasNext()) {
            StatusCauseBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StatusCause> getCauses() {
        return StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public List<StatusCause> buildCauses() {
        return StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public StatusCause buildCause(int index) {
        return this.causes.get(index).build();
    }

    @Override
    public StatusCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    @Override
    public StatusCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    @Override
    public StatusCause buildMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCauses(List<StatusCause> causes) {
        if (this.causes != null) {
            this._visitables.get("causes").removeAll(this.causes);
        }
        if (causes != null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        } else {
            this.causes = null;
        }
        return (A)this;
    }

    @Override
    public A withCauses(StatusCause ... causes) {
        if (this.causes != null) {
            this.causes.clear();
        }
        if (causes != null) {
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    @Override
    public A addNewCause(String field, String message, String reason) {
        return this.addToCauses(new StatusCause(field, message, reason));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> addNewCause() {
        return new CausesNestedImpl();
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> addNewCauseLike(StatusCause item) {
        return new CausesNestedImpl(-1, item);
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> setNewCauseLike(int index, StatusCause item) {
        return new CausesNestedImpl(index, item);
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editCause(int index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.apply(this.causes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public A withNewGroup(String arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public A withNewGroup(StringBuilder arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public A withNewGroup(StringBuffer arg1) {
        return this.withGroup(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public Integer getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Override
    public A withRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasRetryAfterSeconds() {
        return this.retryAfterSeconds != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A withNewUid(String arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuilder arg1) {
        return this.withUid(new String(arg1));
    }

    @Override
    public A withNewUid(StringBuffer arg1) {
        return this.withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDetailsFluentImpl that = (StatusDetailsFluentImpl)o;
        if (this.causes != null ? !this.causes.equals(that.causes) : that.causes != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.retryAfterSeconds != null ? !this.retryAfterSeconds.equals(that.retryAfterSeconds) : that.retryAfterSeconds != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public class CausesNestedImpl<N>
    extends StatusCauseFluentImpl<StatusDetailsFluent.CausesNested<N>>
    implements StatusDetailsFluent.CausesNested<N>,
    Nested<N> {
        private final StatusCauseBuilder builder;
        private final int index;

        CausesNestedImpl(int index, StatusCause item) {
            this.index = index;
            this.builder = new StatusCauseBuilder(this, item);
        }

        CausesNestedImpl() {
            this.index = -1;
            this.builder = new StatusCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatusDetailsFluentImpl.this.setToCauses(this.index, this.builder.build());
        }

        @Override
        public N endCause() {
            return this.and();
        }
    }
}

