package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceSpecBuilder extends APIServiceSpecFluentImpl<APIServiceSpecBuilder> implements VisitableBuilder<APIServiceSpec,APIServiceSpecBuilder> {

    APIServiceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceSpecBuilder() { 
        this(true);
    }


    public APIServiceSpecBuilder(Boolean validationEnabled) { 
        this(new APIServiceSpec(), validationEnabled);
    }


    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new APIServiceSpec(), validationEnabled);
    }


    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent,APIServiceSpec instance) { 
        this(fluent, instance, true);
    }


    public APIServiceSpecBuilder(APIServiceSpecFluent<?> fluent,APIServiceSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCaBundle(instance.getCaBundle()); 
        fluent.withGroup(instance.getGroup()); 
        fluent.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
        fluent.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
        fluent.withService(instance.getService()); 
        fluent.withVersion(instance.getVersion()); 
        fluent.withVersionPriority(instance.getVersionPriority()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServiceSpecBuilder(APIServiceSpec instance) { 
        this(instance,true);
    }


    public APIServiceSpecBuilder(APIServiceSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCaBundle(instance.getCaBundle()); 
        this.withGroup(instance.getGroup()); 
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
        this.withService(instance.getService()); 
        this.withVersion(instance.getVersion()); 
        this.withVersionPriority(instance.getVersionPriority()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServiceSpec build() {
        APIServiceSpec buildable = new APIServiceSpec(fluent.getCaBundle(),fluent.getGroup(),fluent.getGroupPriorityMinimum(),fluent.isInsecureSkipTLSVerify(),fluent.getService(),fluent.getVersion(),fluent.getVersionPriority());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServiceSpecBuilder that = (APIServiceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
