package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerIngressBuilder extends LoadBalancerIngressFluentImpl<LoadBalancerIngressBuilder> implements VisitableBuilder<LoadBalancerIngress,LoadBalancerIngressBuilder> {

    LoadBalancerIngressFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerIngressBuilder() { 
        this(true);
    }


    public LoadBalancerIngressBuilder(Boolean validationEnabled) { 
        this(new LoadBalancerIngress(), validationEnabled);
    }


    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) { 
        this(fluent, true);
    }


    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new LoadBalancerIngress(), validationEnabled);
    }


    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance) { 
        this(fluent, instance, true);
    }


    public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withHostname(instance.getHostname()); 
        fluent.withIp(instance.getIp()); 
        this.validationEnabled = validationEnabled; 
    }


    public LoadBalancerIngressBuilder(LoadBalancerIngress instance) { 
        this(instance,true);
    }


    public LoadBalancerIngressBuilder(LoadBalancerIngress instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withHostname(instance.getHostname()); 
        this.withIp(instance.getIp()); 
        this.validationEnabled = validationEnabled; 
    }


    public LoadBalancerIngress build() {
        LoadBalancerIngress buildable = new LoadBalancerIngress(fluent.getHostname(),fluent.getIp());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LoadBalancerIngressBuilder that = (LoadBalancerIngressBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
