package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface ResourceFieldSelectorFluent<A extends ResourceFieldSelectorFluent<A>> extends Fluent<A> {


    public String getContainerName();
    public A withContainerName(String containerName);
    public Boolean hasContainerName();
    public A withNewContainerName(String arg1);
    public A withNewContainerName(StringBuilder arg1);
    public A withNewContainerName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildDivisor instead.
 * @return The buildable object.
 */
@Deprecated public Quantity getDivisor();
    public Quantity buildDivisor();
    public A withDivisor(Quantity divisor);
    public Boolean hasDivisor();
    public A withNewDivisor(String amount,String format);
    public A withNewDivisor(String amount);
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor();
    public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(Quantity item);
    public ResourceFieldSelectorFluent.DivisorNested<A> editDivisor();
    public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisor();
    public ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisorLike(Quantity item);
    public String getResource();
    public A withResource(String resource);
    public Boolean hasResource();
    public A withNewResource(String arg1);
    public A withNewResource(StringBuilder arg1);
    public A withNewResource(StringBuffer arg1);
    public interface DivisorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuantityFluent<ResourceFieldSelectorFluent.DivisorNested<N>> {

        public N and();
        public N endDivisor();    }


}
