package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceListBuilder extends APIServiceListFluentImpl<APIServiceListBuilder> implements VisitableBuilder<APIServiceList,APIServiceListBuilder> {

    APIServiceListFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceListBuilder() { 
        this(true);
    }


    public APIServiceListBuilder(Boolean validationEnabled) { 
        this(new APIServiceList(), validationEnabled);
    }


    public APIServiceListBuilder(APIServiceListFluent<?> fluent) { 
        this(fluent, true);
    }


    public APIServiceListBuilder(APIServiceListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new APIServiceList(), validationEnabled);
    }


    public APIServiceListBuilder(APIServiceListFluent<?> fluent,APIServiceList instance) { 
        this(fluent, instance, true);
    }


    public APIServiceListBuilder(APIServiceListFluent<?> fluent,APIServiceList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServiceListBuilder(APIServiceList instance) { 
        this(instance,true);
    }


    public APIServiceListBuilder(APIServiceList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public APIServiceList build() {
        APIServiceList buildable = new APIServiceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServiceListBuilder that = (APIServiceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
