package io.fabric8.kubernetes.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface AzureDiskVolumeSourceFluent<A extends AzureDiskVolumeSourceFluent<A>> extends Fluent<A> {


    public String getCachingMode();
    public A withCachingMode(String cachingMode);
    public Boolean hasCachingMode();
    public A withNewCachingMode(String arg1);
    public A withNewCachingMode(StringBuilder arg1);
    public A withNewCachingMode(StringBuffer arg1);
    public String getDiskName();
    public A withDiskName(String diskName);
    public Boolean hasDiskName();
    public A withNewDiskName(String arg1);
    public A withNewDiskName(StringBuilder arg1);
    public A withNewDiskName(StringBuffer arg1);
    public String getDiskURI();
    public A withDiskURI(String diskURI);
    public Boolean hasDiskURI();
    public A withNewDiskURI(String arg1);
    public A withNewDiskURI(StringBuilder arg1);
    public A withNewDiskURI(StringBuffer arg1);
    public String getFsType();
    public A withFsType(String fsType);
    public Boolean hasFsType();
    public A withNewFsType(String arg1);
    public A withNewFsType(StringBuilder arg1);
    public A withNewFsType(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public A withNewReadOnly(String arg1);
    public A withNewReadOnly(boolean arg1);
}
