package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class EndpointSubsetFluentImpl<A extends io.fabric8.kubernetes.api.model.EndpointSubsetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.EndpointSubsetFluent<A>{
  public EndpointSubsetFluentImpl() {
  }
  public EndpointSubsetFluentImpl(io.fabric8.kubernetes.api.model.EndpointSubset instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withNotReadyAddresses(instance.getNotReadyAddresses()); 
    this.withPorts(instance.getPorts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> addresses =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> notReadyAddresses =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.EndpointPortBuilder> ports =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointPortBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items) {
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> getAddresses() {
    return build(addresses);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> buildAddresses() {
    return build(addresses);
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildAddress(java.lang.Integer index) {
    return this.addresses.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>(); for (io.fabric8.kubernetes.api.model.EndpointAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (io.fabric8.kubernetes.api.model.EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.AddressesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(io.fabric8.kubernetes.api.model.EndpointAddress item) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.AddressesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.AddressesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editAddress(java.lang.Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public A addToNotReadyAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(index >= 0 ? index : _visitables.get("notReadyAddresses").size(), builder);this.notReadyAddresses.add(index >= 0 ? index : notReadyAddresses.size(), builder); return (A)this;
  }
  public A setToNotReadyAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("notReadyAddresses").size()) { _visitables.get("notReadyAddresses").add(builder); } else { _visitables.get("notReadyAddresses").set(index, builder);}
    if (index < 0 || index >= notReadyAddresses.size()) { notReadyAddresses.add(builder); } else { notReadyAddresses.set(index, builder);}
     return (A)this;
  }
  public A addToNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(builder);this.notReadyAddresses.add(builder);} return (A)this;
  }
  public A addAllToNotReadyAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items) {
    if (this.notReadyAddresses == null) {this.notReadyAddresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").add(builder);this.notReadyAddresses.add(builder);} return (A)this;
  }
  public A removeFromNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... items) {
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").remove(builder);if (this.notReadyAddresses != null) {this.notReadyAddresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromNotReadyAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointAddress> items) {
    for (io.fabric8.kubernetes.api.model.EndpointAddress item : items) {io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(item);_visitables.get("notReadyAddresses").remove(builder);if (this.notReadyAddresses != null) {this.notReadyAddresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNotReadyAddresses(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    if (notReadyAddresses == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> each = notReadyAddresses.iterator();
    final List visitables = _visitables.get("notReadyAddresses");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNotReadyAddresses instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> getNotReadyAddresses() {
    return build(notReadyAddresses);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> buildNotReadyAddresses() {
    return build(notReadyAddresses);
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildNotReadyAddress(java.lang.Integer index) {
    return this.notReadyAddresses.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildFirstNotReadyAddress() {
    return this.notReadyAddresses.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildLastNotReadyAddress() {
    return this.notReadyAddresses.get(notReadyAddresses.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointAddress buildMatchingNotReadyAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointAddressBuilder item: notReadyAddresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingNotReadyAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointAddressBuilder item: notReadyAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotReadyAddresses(java.util.List<io.fabric8.kubernetes.api.model.EndpointAddress> notReadyAddresses) {
    if (this.notReadyAddresses != null) { _visitables.get("notReadyAddresses").removeAll(this.notReadyAddresses);}
    if (notReadyAddresses != null) {this.notReadyAddresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointAddressBuilder>(); for (io.fabric8.kubernetes.api.model.EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} else { this.notReadyAddresses = null;} return (A) this;
  }
  public A withNotReadyAddresses(io.fabric8.kubernetes.api.model.EndpointAddress... notReadyAddresses) {
    if (this.notReadyAddresses != null) {this.notReadyAddresses.clear();}
    if (notReadyAddresses != null) {for (io.fabric8.kubernetes.api.model.EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasNotReadyAddresses() {
    return notReadyAddresses != null && !notReadyAddresses.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.NotReadyAddressesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(io.fabric8.kubernetes.api.model.EndpointAddress item) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.NotReadyAddressesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.NotReadyAddressesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(java.lang.Integer index) {
    if (notReadyAddresses.size() <= index) throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress() {
    if (notReadyAddresses.size() == 0) throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
    return setNewNotReadyAddressLike(0, buildNotReadyAddress(0));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress() {
    int index = notReadyAddresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<notReadyAddresses.size();i++) { 
    if (predicate.test(notReadyAddresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
    return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
  }
  public A addToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointPort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointPortBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointPort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointPortBuilder>();}
    io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.EndpointPort... items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointPortBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointPort item : items) {io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointPort> items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointPortBuilder>();}
    for (io.fabric8.kubernetes.api.model.EndpointPort item : items) {io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.EndpointPort... items) {
    for (io.fabric8.kubernetes.api.model.EndpointPort item : items) {io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.EndpointPort> items) {
    for (io.fabric8.kubernetes.api.model.EndpointPort item : items) {io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.EndpointPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.EndpointPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointPort> getPorts() {
    return build(ports);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EndpointPort> buildPorts() {
    return build(ports);
  }
  public io.fabric8.kubernetes.api.model.EndpointPort buildPort(java.lang.Integer index) {
    return this.ports.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.EndpointPort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.EndpointPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.EndpointPort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EndpointPortBuilder>(); for (io.fabric8.kubernetes.api.model.EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.EndpointPort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (io.fabric8.kubernetes.api.model.EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public java.lang.Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(java.lang.String appProtocol,java.lang.String name,java.lang.Integer port,java.lang.String protocol) {
    return (A)addToPorts(new EndpointPort(appProtocol, name, port, protocol));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> addNewPort() {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.PortsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.EndpointPort item) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.PortsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> setNewPortLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointPort item) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl.PortsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editPort(java.lang.Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EndpointPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  notReadyAddresses,  ports,  additionalProperties,  super.hashCode());
  }
  public class AddressesNestedImpl<N> extends io.fabric8.kubernetes.api.model.EndpointAddressFluentImpl<io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<N>> implements io.fabric8.kubernetes.api.model.EndpointSubsetFluent.AddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    AddressesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointSubsetFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  public class NotReadyAddressesNestedImpl<N> extends io.fabric8.kubernetes.api.model.EndpointAddressFluentImpl<io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<N>> implements io.fabric8.kubernetes.api.model.EndpointSubsetFluent.NotReadyAddressesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NotReadyAddressesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointAddress item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(this, item);
    }
    NotReadyAddressesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointAddressBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointAddressBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointSubsetFluentImpl.this.setToNotReadyAddresses(index,builder.build());
    }
    public N endNotReadyAddress() {
      return and();
    }
    
  }
  public class PortsNestedImpl<N> extends io.fabric8.kubernetes.api.model.EndpointPortFluentImpl<io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.EndpointSubsetFluent.PortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PortsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.EndpointPort item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.EndpointPortBuilder(this);
    }
    io.fabric8.kubernetes.api.model.EndpointPortBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) EndpointSubsetFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}