package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LabelSelectorBuilder extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.LabelSelectorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LabelSelector,io.fabric8.kubernetes.api.model.LabelSelectorBuilder>{
  public LabelSelectorBuilder() {
    this(false);
  }
  public LabelSelectorBuilder(java.lang.Boolean validationEnabled) {
    this(new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.LabelSelector instance) {
    this(fluent, instance, false);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.LabelSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchExpressions(instance.getMatchExpressions()); 
    fluent.withMatchLabels(instance.getMatchLabels()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelector instance) {
    this(instance,false);
  }
  public LabelSelectorBuilder(io.fabric8.kubernetes.api.model.LabelSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withMatchLabels(instance.getMatchLabels()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LabelSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LabelSelector build() {
    LabelSelector buildable = new LabelSelector(fluent.getMatchExpressions(),fluent.getMatchLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LabelSelectorBuilder that = (LabelSelectorBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}