package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConfigMapNodeConfigSourceBuilder extends io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluentImpl<io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource,io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceBuilder>{
  public ConfigMapNodeConfigSourceBuilder() {
    this(false);
  }
  public ConfigMapNodeConfigSourceBuilder(java.lang.Boolean validationEnabled) {
    this(new ConfigMapNodeConfigSource(), validationEnabled);
  }
  public ConfigMapNodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapNodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapNodeConfigSource(), validationEnabled);
  }
  public ConfigMapNodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapNodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKubeletConfigKey(instance.getKubeletConfigKey()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapNodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource instance) {
    this(instance,false);
  }
  public ConfigMapNodeConfigSourceBuilder(io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKubeletConfigKey(instance.getKubeletConfigKey()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ConfigMapNodeConfigSource build() {
    ConfigMapNodeConfigSource buildable = new ConfigMapNodeConfigSource(fluent.getKubeletConfigKey(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigMapNodeConfigSourceBuilder that = (ConfigMapNodeConfigSourceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}