package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ContainerStateTerminatedBuilder extends io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentImpl<io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ContainerStateTerminated,io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder>{
  public ContainerStateTerminatedBuilder() {
    this(false);
  }
  public ContainerStateTerminatedBuilder(java.lang.Boolean validationEnabled) {
    this(new ContainerStateTerminated(), validationEnabled);
  }
  public ContainerStateTerminatedBuilder(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerStateTerminatedBuilder(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerStateTerminated(), validationEnabled);
  }
  public ContainerStateTerminatedBuilder(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStateTerminated instance) {
    this(fluent, instance, false);
  }
  public ContainerStateTerminatedBuilder(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent<?> fluent,io.fabric8.kubernetes.api.model.ContainerStateTerminated instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerID(instance.getContainerID()); 
    fluent.withExitCode(instance.getExitCode()); 
    fluent.withFinishedAt(instance.getFinishedAt()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withSignal(instance.getSignal()); 
    fluent.withStartedAt(instance.getStartedAt()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerStateTerminatedBuilder(io.fabric8.kubernetes.api.model.ContainerStateTerminated instance) {
    this(instance,false);
  }
  public ContainerStateTerminatedBuilder(io.fabric8.kubernetes.api.model.ContainerStateTerminated instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerID(instance.getContainerID()); 
    this.withExitCode(instance.getExitCode()); 
    this.withFinishedAt(instance.getFinishedAt()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withSignal(instance.getSignal()); 
    this.withStartedAt(instance.getStartedAt()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ContainerStateTerminated build() {
    ContainerStateTerminated buildable = new ContainerStateTerminated(fluent.getContainerID(),fluent.getExitCode(),fluent.getFinishedAt(),fluent.getMessage(),fluent.getReason(),fluent.getSignal(),fluent.getStartedAt());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerStateTerminatedBuilder that = (ContainerStateTerminatedBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}