package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LifecycleHandlerBuilder extends io.fabric8.kubernetes.api.model.LifecycleHandlerFluentImpl<io.fabric8.kubernetes.api.model.LifecycleHandlerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LifecycleHandler,io.fabric8.kubernetes.api.model.LifecycleHandlerBuilder>{
  public LifecycleHandlerBuilder() {
    this(false);
  }
  public LifecycleHandlerBuilder(java.lang.Boolean validationEnabled) {
    this(new LifecycleHandler(), validationEnabled);
  }
  public LifecycleHandlerBuilder(io.fabric8.kubernetes.api.model.LifecycleHandlerFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleHandlerBuilder(io.fabric8.kubernetes.api.model.LifecycleHandlerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LifecycleHandler(), validationEnabled);
  }
  public LifecycleHandlerBuilder(io.fabric8.kubernetes.api.model.LifecycleHandlerFluent<?> fluent,io.fabric8.kubernetes.api.model.LifecycleHandler instance) {
    this(fluent, instance, false);
  }
  public LifecycleHandlerBuilder(io.fabric8.kubernetes.api.model.LifecycleHandlerFluent<?> fluent,io.fabric8.kubernetes.api.model.LifecycleHandler instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExec(instance.getExec()); 
    fluent.withHttpGet(instance.getHttpGet()); 
    fluent.withTcpSocket(instance.getTcpSocket()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LifecycleHandlerBuilder(io.fabric8.kubernetes.api.model.LifecycleHandler instance) {
    this(instance,false);
  }
  public LifecycleHandlerBuilder(io.fabric8.kubernetes.api.model.LifecycleHandler instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExec(instance.getExec()); 
    this.withHttpGet(instance.getHttpGet()); 
    this.withTcpSocket(instance.getTcpSocket()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LifecycleHandlerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LifecycleHandler build() {
    LifecycleHandler buildable = new LifecycleHandler(fluent.getExec(),fluent.getHttpGet(),fluent.getTcpSocket());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LifecycleHandlerBuilder that = (LifecycleHandlerBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}