package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ResourceFieldSelectorBuilder extends io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluentImpl<io.fabric8.kubernetes.api.model.ResourceFieldSelectorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.ResourceFieldSelector,io.fabric8.kubernetes.api.model.ResourceFieldSelectorBuilder>{
  public ResourceFieldSelectorBuilder() {
    this(false);
  }
  public ResourceFieldSelectorBuilder(java.lang.Boolean validationEnabled) {
    this(new ResourceFieldSelector(), validationEnabled);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceFieldSelector(), validationEnabled);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceFieldSelector instance) {
    this(fluent, instance, false);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceFieldSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withDivisor(instance.getDivisor()); 
    fluent.withResource(instance.getResource()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelector instance) {
    this(instance,false);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerName(instance.getContainerName()); 
    this.withDivisor(instance.getDivisor()); 
    this.withResource(instance.getResource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ResourceFieldSelector build() {
    ResourceFieldSelector buildable = new ResourceFieldSelector(fluent.getContainerName(),fluent.getDivisor(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceFieldSelectorBuilder that = (ResourceFieldSelectorBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}