package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class SecretKeySelectorBuilder extends io.fabric8.kubernetes.api.model.SecretKeySelectorFluentImpl<io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.SecretKeySelector,io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder>{
  public SecretKeySelectorBuilder() {
    this(false);
  }
  public SecretKeySelectorBuilder(java.lang.Boolean validationEnabled) {
    this(new SecretKeySelector(), validationEnabled);
  }
  public SecretKeySelectorBuilder(io.fabric8.kubernetes.api.model.SecretKeySelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretKeySelectorBuilder(io.fabric8.kubernetes.api.model.SecretKeySelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretKeySelector(), validationEnabled);
  }
  public SecretKeySelectorBuilder(io.fabric8.kubernetes.api.model.SecretKeySelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretKeySelector instance) {
    this(fluent, instance, false);
  }
  public SecretKeySelectorBuilder(io.fabric8.kubernetes.api.model.SecretKeySelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretKeySelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKey(instance.getKey()); 
    fluent.withName(instance.getName()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretKeySelectorBuilder(io.fabric8.kubernetes.api.model.SecretKeySelector instance) {
    this(instance,false);
  }
  public SecretKeySelectorBuilder(io.fabric8.kubernetes.api.model.SecretKeySelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKey(instance.getKey()); 
    this.withName(instance.getName()); 
    this.withOptional(instance.getOptional()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretKeySelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecretKeySelector build() {
    SecretKeySelector buildable = new SecretKeySelector(fluent.getKey(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretKeySelectorBuilder that = (SecretKeySelectorBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}