package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TopologySpreadConstraintBuilder extends io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluentImpl<io.fabric8.kubernetes.api.model.TopologySpreadConstraintBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.TopologySpreadConstraint,io.fabric8.kubernetes.api.model.TopologySpreadConstraintBuilder>{
  public TopologySpreadConstraintBuilder() {
    this(false);
  }
  public TopologySpreadConstraintBuilder(java.lang.Boolean validationEnabled) {
    this(new TopologySpreadConstraint(), validationEnabled);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent) {
    this(fluent, false);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TopologySpreadConstraint(), validationEnabled);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent,io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance) {
    this(fluent, instance, false);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent,io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withMaxSkew(instance.getMaxSkew()); 
    fluent.withTopologyKey(instance.getTopologyKey()); 
    fluent.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance) {
    this(instance,false);
  }
  public TopologySpreadConstraintBuilder(io.fabric8.kubernetes.api.model.TopologySpreadConstraint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withMaxSkew(instance.getMaxSkew()); 
    this.withTopologyKey(instance.getTopologyKey()); 
    this.withWhenUnsatisfiable(instance.getWhenUnsatisfiable()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint build() {
    TopologySpreadConstraint buildable = new TopologySpreadConstraint(fluent.getLabelSelector(),fluent.getMaxSkew(),fluent.getTopologyKey(),fluent.getWhenUnsatisfiable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TopologySpreadConstraintBuilder that = (TopologySpreadConstraintBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}