package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LoadBalancerStatusBuilder extends io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl<io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.LoadBalancerStatus,io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder>{
  public LoadBalancerStatusBuilder() {
    this(false);
  }
  public LoadBalancerStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new LoadBalancerStatus(), validationEnabled);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LoadBalancerStatus(), validationEnabled);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerStatus instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.LoadBalancerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIngress(instance.getIngress()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatus instance) {
    this(instance,false);
  }
  public LoadBalancerStatusBuilder(io.fabric8.kubernetes.api.model.LoadBalancerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIngress(instance.getIngress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.LoadBalancerStatus build() {
    LoadBalancerStatus buildable = new LoadBalancerStatus(fluent.getIngress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LoadBalancerStatusBuilder that = (LoadBalancerStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}