package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIGroupBuilder extends io.fabric8.kubernetes.api.model.APIGroupFluentImpl<io.fabric8.kubernetes.api.model.APIGroupBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.APIGroup,io.fabric8.kubernetes.api.model.APIGroupBuilder> {

    io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public APIGroupBuilder() {
        this(true);
    }

    public APIGroupBuilder(java.lang.Boolean validationEnabled) {
        this(new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent) {
        this(fluent, true);
    }

    public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroup instance) {
        this(fluent, instance, true);
    }

    public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroupFluent<?> fluent,io.fabric8.kubernetes.api.model.APIGroup instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withPreferredVersion(instance.getPreferredVersion()); 
        fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs()); 
        fluent.withVersions(instance.getVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroup instance) {
        this(instance,true);
    }

    public APIGroupBuilder(io.fabric8.kubernetes.api.model.APIGroup instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withPreferredVersion(instance.getPreferredVersion()); 
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs()); 
        this.withVersions(instance.getVersions()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.APIGroup build() {
        APIGroup buildable = new APIGroup(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getPreferredVersion(),fluent.getServerAddressByClientCIDRs(),fluent.getVersions());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIGroupBuilder that = (APIGroupBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
