package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BaseKubernetesListBuilder extends io.fabric8.kubernetes.api.model.BaseKubernetesListFluentImpl<io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.BaseKubernetesList,io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder> {

    io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BaseKubernetesListBuilder() {
        this(true);
    }

    public BaseKubernetesListBuilder(java.lang.Boolean validationEnabled) {
        this(new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent) {
        this(fluent, true);
    }

    public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent,io.fabric8.kubernetes.api.model.BaseKubernetesList instance) {
        this(fluent, instance, true);
    }

    public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent<?> fluent,io.fabric8.kubernetes.api.model.BaseKubernetesList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesList instance) {
        this(instance,true);
    }

    public BaseKubernetesListBuilder(io.fabric8.kubernetes.api.model.BaseKubernetesList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.BaseKubernetesList build() {
        BaseKubernetesList buildable = new BaseKubernetesList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BaseKubernetesListBuilder that = (BaseKubernetesListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
