package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointAddressBuilder extends io.fabric8.kubernetes.api.model.EndpointAddressFluentImpl<io.fabric8.kubernetes.api.model.EndpointAddressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.EndpointAddress,io.fabric8.kubernetes.api.model.EndpointAddressBuilder> {

    io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EndpointAddressBuilder() {
        this(true);
    }

    public EndpointAddressBuilder(java.lang.Boolean validationEnabled) {
        this(new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointAddress instance) {
        this(fluent, instance, true);
    }

    public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddressFluent<?> fluent,io.fabric8.kubernetes.api.model.EndpointAddress instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHostname(instance.getHostname()); 
        fluent.withIp(instance.getIp()); 
        fluent.withNodeName(instance.getNodeName()); 
        fluent.withTargetRef(instance.getTargetRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddress instance) {
        this(instance,true);
    }

    public EndpointAddressBuilder(io.fabric8.kubernetes.api.model.EndpointAddress instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHostname(instance.getHostname()); 
        this.withIp(instance.getIp()); 
        this.withNodeName(instance.getNodeName()); 
        this.withTargetRef(instance.getTargetRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.EndpointAddress build() {
        EndpointAddress buildable = new EndpointAddress(fluent.getHostname(),fluent.getIp(),fluent.getNodeName(),fluent.getTargetRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointAddressBuilder that = (EndpointAddressBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
