package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GlusterfsPersistentVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource,io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public GlusterfsPersistentVolumeSourceBuilder() {
        this(true);
    }

    public GlusterfsPersistentVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new GlusterfsPersistentVolumeSource(), validationEnabled);
    }

    public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new GlusterfsPersistentVolumeSource(), validationEnabled);
    }

    public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance) {
        this(fluent, instance, true);
    }

    public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEndpoints(instance.getEndpoints()); 
        fluent.withEndpointsNamespace(instance.getEndpointsNamespace()); 
        fluent.withPath(instance.getPath()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        this.validationEnabled = validationEnabled; 
    }

    public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance) {
        this(instance,true);
    }

    public GlusterfsPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withEndpoints(instance.getEndpoints()); 
        this.withEndpointsNamespace(instance.getEndpointsNamespace()); 
        this.withPath(instance.getPath()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.GlusterfsPersistentVolumeSource build() {
        GlusterfsPersistentVolumeSource buildable = new GlusterfsPersistentVolumeSource(fluent.getEndpoints(),fluent.getEndpointsNamespace(),fluent.getPath(),fluent.getReadOnly());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GlusterfsPersistentVolumeSourceBuilder that = (GlusterfsPersistentVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
