package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodDNSConfigFluentImpl<A extends io.fabric8.kubernetes.api.model.PodDNSConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.PodDNSConfigFluent<A> {

    private java.util.List<java.lang.String> nameservers = new java.util.ArrayList<java.lang.String>();
    private java.util.List<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder> options =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder>();
    private java.util.List<java.lang.String> searches = new java.util.ArrayList<java.lang.String>();

    public PodDNSConfigFluentImpl() {
    }

    public PodDNSConfigFluentImpl(io.fabric8.kubernetes.api.model.PodDNSConfig instance) {
        this.withNameservers(instance.getNameservers()); 
        this.withOptions(instance.getOptions()); 
        this.withSearches(instance.getSearches()); 
    }

    public A addToNameservers(int index,java.lang.String item) {
        if (this.nameservers == null) {this.nameservers = new java.util.ArrayList<java.lang.String>();}
        this.nameservers.add(index, item);
        return (A)this;
    }

    public A setToNameservers(int index,java.lang.String item) {
        if (this.nameservers == null) {this.nameservers = new java.util.ArrayList<java.lang.String>();}
        this.nameservers.set(index, item); return (A)this;
    }

    public A addToNameservers(java.lang.String... items) {
        if (this.nameservers == null) {this.nameservers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.nameservers.add(item);} return (A)this;
    }

    public A addAllToNameservers(java.util.Collection<java.lang.String> items) {
        if (this.nameservers == null) {this.nameservers = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.nameservers.add(item);} return (A)this;
    }

    public A removeFromNameservers(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.nameservers!= null){ this.nameservers.remove(item);}} return (A)this;
    }

    public A removeAllFromNameservers(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.nameservers!= null){ this.nameservers.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getNameservers() {
        return this.nameservers;
    }

    public java.lang.String getNameserver(int index) {
        return this.nameservers.get(index);
    }

    public java.lang.String getFirstNameserver() {
        return this.nameservers.get(0);
    }

    public java.lang.String getLastNameserver() {
        return this.nameservers.get(nameservers.size() - 1);
    }

    public java.lang.String getMatchingNameserver(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: nameservers) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingNameserver(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: nameservers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNameservers(java.util.List<java.lang.String> nameservers) {
        if (this.nameservers != null) { _visitables.get("nameservers").removeAll(this.nameservers);}
        if (nameservers != null) {this.nameservers = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : nameservers){this.addToNameservers(item);}} else { this.nameservers = null;} return (A) this;
    }

    public A withNameservers(java.lang.String... nameservers) {
        if (this.nameservers != null) {this.nameservers.clear();}
        if (nameservers != null) {for (java.lang.String item :nameservers){ this.addToNameservers(item);}} return (A) this;
    }

    public java.lang.Boolean hasNameservers() {
        return nameservers != null && !nameservers.isEmpty();
    }

    public A addNewNameserver(java.lang.String arg0) {
        return (A)addToNameservers(new String(arg0));
    }

    public A addToOptions(int index,io.fabric8.kubernetes.api.model.PodDNSConfigOption item) {
        if (this.options == null) {this.options = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder>();}
        io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(item);_visitables.get("options").add(index >= 0 ? index : _visitables.get("options").size(), builder);this.options.add(index >= 0 ? index : options.size(), builder); return (A)this;
    }

    public A setToOptions(int index,io.fabric8.kubernetes.api.model.PodDNSConfigOption item) {
        if (this.options == null) {this.options = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder>();}
        io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(item);
        if (index < 0 || index >= _visitables.get("options").size()) { _visitables.get("options").add(builder); } else { _visitables.get("options").set(index, builder);}
        if (index < 0 || index >= options.size()) { options.add(builder); } else { options.set(index, builder);}
         return (A)this;
    }

    public A addToOptions(io.fabric8.kubernetes.api.model.PodDNSConfigOption... items) {
        if (this.options == null) {this.options = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder>();}
        for (io.fabric8.kubernetes.api.model.PodDNSConfigOption item : items) {io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(item);_visitables.get("options").add(builder);this.options.add(builder);} return (A)this;
    }

    public A addAllToOptions(java.util.Collection<io.fabric8.kubernetes.api.model.PodDNSConfigOption> items) {
        if (this.options == null) {this.options = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder>();}
        for (io.fabric8.kubernetes.api.model.PodDNSConfigOption item : items) {io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(item);_visitables.get("options").add(builder);this.options.add(builder);} return (A)this;
    }

    public A removeFromOptions(io.fabric8.kubernetes.api.model.PodDNSConfigOption... items) {
        for (io.fabric8.kubernetes.api.model.PodDNSConfigOption item : items) {io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(item);_visitables.get("options").remove(builder);if (this.options != null) {this.options.remove(builder);}} return (A)this;
    }

    public A removeAllFromOptions(java.util.Collection<io.fabric8.kubernetes.api.model.PodDNSConfigOption> items) {
        for (io.fabric8.kubernetes.api.model.PodDNSConfigOption item : items) {io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(item);_visitables.get("options").remove(builder);if (this.options != null) {this.options.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOptions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder> predicate) {
        if (options == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder> each = options.iterator();
        final List visitables = _visitables.get("options");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildOptions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.PodDNSConfigOption> getOptions() {
        return build(options);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.PodDNSConfigOption> buildOptions() {
        return build(options);
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigOption buildOption(int index) {
        return this.options.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigOption buildFirstOption() {
        return this.options.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigOption buildLastOption() {
        return this.options.get(options.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigOption buildMatchingOption(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder item: options) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingOption(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder item: options) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withOptions(java.util.List<io.fabric8.kubernetes.api.model.PodDNSConfigOption> options) {
        if (this.options != null) { _visitables.get("options").removeAll(this.options);}
        if (options != null) {this.options = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder>(); for (io.fabric8.kubernetes.api.model.PodDNSConfigOption item : options){this.addToOptions(item);}} else { this.options = null;} return (A) this;
    }

    public A withOptions(io.fabric8.kubernetes.api.model.PodDNSConfigOption... options) {
        if (this.options != null) {this.options.clear();}
        if (options != null) {for (io.fabric8.kubernetes.api.model.PodDNSConfigOption item :options){ this.addToOptions(item);}} return (A) this;
    }

    public java.lang.Boolean hasOptions() {
        return options != null && !options.isEmpty();
    }

    public A addNewOption(java.lang.String name,java.lang.String value) {
        return (A)addToOptions(new PodDNSConfigOption(name, value));
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> addNewOption() {
        return new io.fabric8.kubernetes.api.model.PodDNSConfigFluentImpl.OptionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> addNewOptionLike(io.fabric8.kubernetes.api.model.PodDNSConfigOption item) {
        return new io.fabric8.kubernetes.api.model.PodDNSConfigFluentImpl.OptionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> setNewOptionLike(int index,io.fabric8.kubernetes.api.model.PodDNSConfigOption item) {
        return new io.fabric8.kubernetes.api.model.PodDNSConfigFluentImpl.OptionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> editOption(int index) {
        if (options.size() <= index) throw new RuntimeException("Can't edit options. Index exceeds size.");
        return setNewOptionLike(index, buildOption(index));
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> editFirstOption() {
        if (options.size() == 0) throw new RuntimeException("Can't edit first options. The list is empty.");
        return setNewOptionLike(0, buildOption(0));
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> editLastOption() {
        int index = options.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last options. The list is empty.");
        return setNewOptionLike(index, buildOption(index));
    }

    public io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<A> editMatchingOption(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<options.size();i++) { 
        if (predicate.test(options.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching options. No match found.");
        return setNewOptionLike(index, buildOption(index));
    }

    public A addToSearches(int index,java.lang.String item) {
        if (this.searches == null) {this.searches = new java.util.ArrayList<java.lang.String>();}
        this.searches.add(index, item);
        return (A)this;
    }

    public A setToSearches(int index,java.lang.String item) {
        if (this.searches == null) {this.searches = new java.util.ArrayList<java.lang.String>();}
        this.searches.set(index, item); return (A)this;
    }

    public A addToSearches(java.lang.String... items) {
        if (this.searches == null) {this.searches = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.searches.add(item);} return (A)this;
    }

    public A addAllToSearches(java.util.Collection<java.lang.String> items) {
        if (this.searches == null) {this.searches = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.searches.add(item);} return (A)this;
    }

    public A removeFromSearches(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.searches!= null){ this.searches.remove(item);}} return (A)this;
    }

    public A removeAllFromSearches(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.searches!= null){ this.searches.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getSearches() {
        return this.searches;
    }

    public java.lang.String getSearch(int index) {
        return this.searches.get(index);
    }

    public java.lang.String getFirstSearch() {
        return this.searches.get(0);
    }

    public java.lang.String getLastSearch() {
        return this.searches.get(searches.size() - 1);
    }

    public java.lang.String getMatchingSearch(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: searches) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingSearch(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: searches) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSearches(java.util.List<java.lang.String> searches) {
        if (this.searches != null) { _visitables.get("searches").removeAll(this.searches);}
        if (searches != null) {this.searches = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : searches){this.addToSearches(item);}} else { this.searches = null;} return (A) this;
    }

    public A withSearches(java.lang.String... searches) {
        if (this.searches != null) {this.searches.clear();}
        if (searches != null) {for (java.lang.String item :searches){ this.addToSearches(item);}} return (A) this;
    }

    public java.lang.Boolean hasSearches() {
        return searches != null && !searches.isEmpty();
    }

    public A addNewSearch(java.lang.String arg0) {
        return (A)addToSearches(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodDNSConfigFluentImpl that = (PodDNSConfigFluentImpl) o;
        if (nameservers != null ? !nameservers.equals(that.nameservers) :that.nameservers != null) return false;
        if (options != null ? !options.equals(that.options) :that.options != null) return false;
        if (searches != null ? !searches.equals(that.searches) :that.searches != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(nameservers,  options,  searches,  super.hashCode());
    }

    public class OptionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluentImpl<io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<N>> implements io.fabric8.kubernetes.api.model.PodDNSConfigFluent.OptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder builder;
        private final int index;

            OptionsNestedImpl(int index,io.fabric8.kubernetes.api.model.PodDNSConfigOption item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(this, item);
                        
            }

            OptionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.PodDNSConfigOptionBuilder(this);
                        
            }

            public N and() {
                return (N) PodDNSConfigFluentImpl.this.setToOptions(index,builder.build());
            }

            public N endOption() {
                return and();
            }
    }


}
