package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodTemplateListBuilder extends io.fabric8.kubernetes.api.model.PodTemplateListFluentImpl<io.fabric8.kubernetes.api.model.PodTemplateListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.PodTemplateList,io.fabric8.kubernetes.api.model.PodTemplateListBuilder> {

    io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodTemplateListBuilder() {
        this(true);
    }

    public PodTemplateListBuilder(java.lang.Boolean validationEnabled) {
        this(new PodTemplateList(), validationEnabled);
    }

    public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent) {
        this(fluent, true);
    }

    public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodTemplateList(), validationEnabled);
    }

    public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplateList instance) {
        this(fluent, instance, true);
    }

    public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplateList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateList instance) {
        this(instance,true);
    }

    public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.PodTemplateList build() {
        PodTemplateList buildable = new PodTemplateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodTemplateListBuilder that = (PodTemplateListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
