package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecretProjectionBuilder extends io.fabric8.kubernetes.api.model.SecretProjectionFluentImpl<io.fabric8.kubernetes.api.model.SecretProjectionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.SecretProjection,io.fabric8.kubernetes.api.model.SecretProjectionBuilder> {

    io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SecretProjectionBuilder() {
        this(true);
    }

    public SecretProjectionBuilder(java.lang.Boolean validationEnabled) {
        this(new SecretProjection(), validationEnabled);
    }

    public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent) {
        this(fluent, true);
    }

    public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SecretProjection(), validationEnabled);
    }

    public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretProjection instance) {
        this(fluent, instance, true);
    }

    public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretProjection instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withItems(instance.getItems()); 
        fluent.withName(instance.getName()); 
        fluent.withOptional(instance.getOptional()); 
        this.validationEnabled = validationEnabled; 
    }

    public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjection instance) {
        this(instance,true);
    }

    public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjection instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withItems(instance.getItems()); 
        this.withName(instance.getName()); 
        this.withOptional(instance.getOptional()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.SecretProjection build() {
        SecretProjection buildable = new SecretProjection(fluent.getItems(),fluent.getName(),fluent.getOptional());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecretProjectionBuilder that = (SecretProjectionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
