package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ServicePortFluentImpl<A extends io.fabric8.kubernetes.api.model.ServicePortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.ServicePortFluent<A> {

    private java.lang.String appProtocol;
    private java.lang.String name;
    private java.lang.Integer nodePort;
    private java.lang.Integer port;
    private java.lang.String protocol;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder targetPort;

    public ServicePortFluentImpl() {
    }

    public ServicePortFluentImpl(io.fabric8.kubernetes.api.model.ServicePort instance) {
        this.withAppProtocol(instance.getAppProtocol()); 
        this.withName(instance.getName()); 
        this.withNodePort(instance.getNodePort()); 
        this.withPort(instance.getPort()); 
        this.withProtocol(instance.getProtocol()); 
        this.withTargetPort(instance.getTargetPort()); 
    }

    public java.lang.String getAppProtocol() {
        return this.appProtocol;
    }

    public A withAppProtocol(java.lang.String appProtocol) {
        this.appProtocol=appProtocol; return (A) this;
    }

    public java.lang.Boolean hasAppProtocol() {
        return this.appProtocol != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAppProtocol instead.
     */
        public A withNewAppProtocol(java.lang.String arg0) {
        return (A)withAppProtocol(new String(arg0));
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public java.lang.Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(java.lang.Integer nodePort) {
        this.nodePort=nodePort; return (A) this;
    }

    public java.lang.Boolean hasNodePort() {
        return this.nodePort != null;
    }

    public java.lang.Integer getPort() {
        return this.port;
    }

    public A withPort(java.lang.Integer port) {
        this.port=port; return (A) this;
    }

    public java.lang.Boolean hasPort() {
        return this.port != null;
    }

    public java.lang.String getProtocol() {
        return this.protocol;
    }

    public A withProtocol(java.lang.String protocol) {
        this.protocol=protocol; return (A) this;
    }

    public java.lang.Boolean hasProtocol() {
        return this.protocol != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProtocol instead.
     */
        public A withNewProtocol(java.lang.String arg0) {
        return (A)withProtocol(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTargetPort instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
        _visitables.get("targetPort").remove(this.targetPort);
        if (targetPort!=null){ this.targetPort= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
    }

    public java.lang.Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(java.lang.Integer intVal) {
        return (A)withTargetPort(new IntOrString(intVal));
    }

    public A withNewTargetPort(java.lang.String strVal) {
        return (A)withTargetPort(new IntOrString(strVal));
    }

    public io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<A> withNewTargetPort() {
        return new io.fabric8.kubernetes.api.model.ServicePortFluentImpl.TargetPortNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.kubernetes.api.model.ServicePortFluentImpl.TargetPortNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<A> editTargetPort() {
        return withNewTargetPortLike(getTargetPort());
    }

    public io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<A> editOrNewTargetPort() {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<A> editOrNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServicePortFluentImpl that = (ServicePortFluentImpl) o;
        if (appProtocol != null ? !appProtocol.equals(that.appProtocol) :that.appProtocol != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
        if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(appProtocol,  name,  nodePort,  port,  protocol,  targetPort,  super.hashCode());
    }

    public class TargetPortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<N>> implements io.fabric8.kubernetes.api.model.ServicePortFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            TargetPortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            TargetPortNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) ServicePortFluentImpl.this.withTargetPort(builder.build());
            }

            public N endTargetPort() {
                return and();
            }
    }


}
