package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StorageOSPersistentVolumeSourceBuilder extends io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceFluentImpl<io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource,io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceBuilder> {

    io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StorageOSPersistentVolumeSourceBuilder() {
        this(true);
    }

    public StorageOSPersistentVolumeSourceBuilder(java.lang.Boolean validationEnabled) {
        this(new StorageOSPersistentVolumeSource(), validationEnabled);
    }

    public StorageOSPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public StorageOSPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StorageOSPersistentVolumeSource(), validationEnabled);
    }

    public StorageOSPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource instance) {
        this(fluent, instance, true);
    }

    public StorageOSPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType()); 
        fluent.withReadOnly(instance.getReadOnly()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        fluent.withVolumeName(instance.getVolumeName()); 
        fluent.withVolumeNamespace(instance.getVolumeNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public StorageOSPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource instance) {
        this(instance,true);
    }

    public StorageOSPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFsType(instance.getFsType()); 
        this.withReadOnly(instance.getReadOnly()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.withVolumeName(instance.getVolumeName()); 
        this.withVolumeNamespace(instance.getVolumeNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.StorageOSPersistentVolumeSource build() {
        StorageOSPersistentVolumeSource buildable = new StorageOSPersistentVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getVolumeName(),fluent.getVolumeNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StorageOSPersistentVolumeSourceBuilder that = (StorageOSPersistentVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
