/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointsFluentImpl<A extends EndpointsFluent<A>>
extends BaseFluent<A>
implements EndpointsFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<EndpointSubsetBuilder> subsets = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EndpointsFluentImpl() {
    }

    public EndpointsFluentImpl(Endpoints instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSubsets(instance.getSubsets());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EndpointsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSubsets(Integer index, EndpointSubset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
        this._visitables.get("subsets").add(index >= 0 ? index.intValue() : this._visitables.get("subsets").size(), builder);
        this.subsets.add(index >= 0 ? index.intValue() : this.subsets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubsets(Integer index, EndpointSubset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
        if (index < 0 || index >= this._visitables.get("subsets").size()) {
            this._visitables.get("subsets").add(builder);
        } else {
            this._visitables.get("subsets").set(index, builder);
        }
        if (index < 0 || index >= this.subsets.size()) {
            this.subsets.add(builder);
        } else {
            this.subsets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubsets(EndpointSubset ... items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubsets(Collection<EndpointSubset> items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubsets(EndpointSubset ... items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubsets(Collection<EndpointSubset> items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubsets(Predicate<EndpointSubsetBuilder> predicate) {
        if (this.subsets == null) {
            return (A)this;
        }
        Iterator<EndpointSubsetBuilder> each = this.subsets.iterator();
        Object visitables = this._visitables.get("subsets");
        while (each.hasNext()) {
            EndpointSubsetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointSubset> getSubsets() {
        return this.subsets != null ? EndpointsFluentImpl.build(this.subsets) : null;
    }

    @Override
    public List<EndpointSubset> buildSubsets() {
        return this.subsets != null ? EndpointsFluentImpl.build(this.subsets) : null;
    }

    @Override
    public EndpointSubset buildSubset(Integer index) {
        return this.subsets.get(index).build();
    }

    @Override
    public EndpointSubset buildFirstSubset() {
        return this.subsets.get(0).build();
    }

    @Override
    public EndpointSubset buildLastSubset() {
        return this.subsets.get(this.subsets.size() - 1).build();
    }

    @Override
    public EndpointSubset buildMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        for (EndpointSubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        for (EndpointSubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubsets(List<EndpointSubset> subsets) {
        if (this.subsets != null) {
            this._visitables.get("subsets").removeAll(this.subsets);
        }
        if (subsets != null) {
            this.subsets = new ArrayList();
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        } else {
            this.subsets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubsets(EndpointSubset ... subsets) {
        if (this.subsets != null) {
            this.subsets.clear();
        }
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubsets() {
        return this.subsets != null && !this.subsets.isEmpty();
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> addNewSubset() {
        return new SubsetsNestedImpl();
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item) {
        return new SubsetsNestedImpl(-1, item);
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> setNewSubsetLike(Integer index, EndpointSubset item) {
        return new SubsetsNestedImpl(index, item);
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editSubset(Integer index) {
        if (this.subsets.size() <= index) {
            throw new RuntimeException("Can't edit subsets. Index exceeds size.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editFirstSubset() {
        if (this.subsets.size() == 0) {
            throw new RuntimeException("Can't edit first subsets. The list is empty.");
        }
        return this.setNewSubsetLike(0, this.buildSubset(0));
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editLastSubset() {
        int index = this.subsets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subsets. The list is empty.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subsets.size(); ++i) {
            if (!predicate.test(this.subsets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subsets. No match found.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointsFluentImpl that = (EndpointsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.subsets != null ? !this.subsets.equals(that.subsets) : that.subsets != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.subsets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.subsets != null && !this.subsets.isEmpty()) {
            sb.append("subsets:");
            sb.append(this.subsets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubsetsNestedImpl<N>
    extends EndpointSubsetFluentImpl<EndpointsFluent.SubsetsNested<N>>
    implements EndpointsFluent.SubsetsNested<N>,
    Nested<N> {
        EndpointSubsetBuilder builder;
        Integer index;

        SubsetsNestedImpl(Integer index, EndpointSubset item) {
            this.index = index;
            this.builder = new EndpointSubsetBuilder(this, item);
        }

        SubsetsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointSubsetBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.setToSubsets(this.index, this.builder.build());
        }

        @Override
        public N endSubset() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EndpointsFluent.MetadataNested<N>>
    implements EndpointsFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

