package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SecretReferenceBuilder extends SecretReferenceFluent<SecretReferenceBuilder> implements VisitableBuilder<SecretReference,SecretReferenceBuilder>{
  public SecretReferenceBuilder() {
    this(new SecretReference());
  }
  
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent) {
    this(fluent, new SecretReference());
  }
  
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent,SecretReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SecretReferenceBuilder(SecretReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SecretReferenceFluent<?> fluent;
  
  public SecretReference build() {
    SecretReference buildable = new SecretReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}