package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClientIPConfigBuilder extends ClientIPConfigFluent<ClientIPConfigBuilder> implements VisitableBuilder<ClientIPConfig,ClientIPConfigBuilder>{
  public ClientIPConfigBuilder() {
    this(new ClientIPConfig());
  }
  
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent) {
    this(fluent, new ClientIPConfig());
  }
  
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent,ClientIPConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClientIPConfigBuilder(ClientIPConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClientIPConfigFluent<?> fluent;
  
  public ClientIPConfig build() {
    ClientIPConfig buildable = new ClientIPConfig(fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}