package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodDNSConfigOptionBuilder extends PodDNSConfigOptionFluent<PodDNSConfigOptionBuilder> implements VisitableBuilder<PodDNSConfigOption,PodDNSConfigOptionBuilder>{
  public PodDNSConfigOptionBuilder() {
    this(new PodDNSConfigOption());
  }
  
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent) {
    this(fluent, new PodDNSConfigOption());
  }
  
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent,PodDNSConfigOption instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodDNSConfigOptionBuilder(PodDNSConfigOption instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodDNSConfigOptionFluent<?> fluent;
  
  public PodDNSConfigOption build() {
    PodDNSConfigOption buildable = new PodDNSConfigOption(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}