package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodListBuilder extends PodListFluent<PodListBuilder> implements VisitableBuilder<PodList,PodListBuilder>{
  public PodListBuilder() {
    this(new PodList());
  }
  
  public PodListBuilder(PodListFluent<?> fluent) {
    this(fluent, new PodList());
  }
  
  public PodListBuilder(PodListFluent<?> fluent,PodList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodListBuilder(PodList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodListFluent<?> fluent;
  
  public PodList build() {
    PodList buildable = new PodList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}