package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AffinityBuilder extends AffinityFluentImpl<AffinityBuilder> implements VisitableBuilder<Affinity,AffinityBuilder>{
  public AffinityBuilder() {
    this(false);
  }
  public AffinityBuilder(Boolean validationEnabled) {
    this(new Affinity(), validationEnabled);
  }
  public AffinityBuilder(AffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public AffinityBuilder(AffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Affinity(), validationEnabled);
  }
  public AffinityBuilder(AffinityFluent<?> fluent,Affinity instance) {
    this(fluent, instance, false);
  }
  public AffinityBuilder(AffinityFluent<?> fluent,Affinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodeAffinity(instance.getNodeAffinity()); 
    fluent.withPodAffinity(instance.getPodAffinity()); 
    fluent.withPodAntiAffinity(instance.getPodAntiAffinity()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AffinityBuilder(Affinity instance) {
    this(instance,false);
  }
  public AffinityBuilder(Affinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodeAffinity(instance.getNodeAffinity()); 
    this.withPodAffinity(instance.getPodAffinity()); 
    this.withPodAntiAffinity(instance.getPodAntiAffinity()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AffinityFluent<?> fluent;
  Boolean validationEnabled;
  public Affinity build() {
    Affinity buildable = new Affinity(fluent.getNodeAffinity(),fluent.getPodAffinity(),fluent.getPodAntiAffinity());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}