package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerSpecBuilder extends ReplicationControllerSpecFluentImpl<ReplicationControllerSpecBuilder> implements VisitableBuilder<ReplicationControllerSpec,ReplicationControllerSpecBuilder>{
  public ReplicationControllerSpecBuilder() {
    this(false);
  }
  public ReplicationControllerSpecBuilder(Boolean validationEnabled) {
    this(new ReplicationControllerSpec(), validationEnabled);
  }
  public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicationControllerSpec(), validationEnabled);
  }
  public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent,ReplicationControllerSpec instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent,ReplicationControllerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance) {
    this(instance,false);
  }
  public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplicationControllerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicationControllerSpec build() {
    ReplicationControllerSpec buildable = new ReplicationControllerSpec(fluent.getMinReadySeconds(),fluent.getReplicas(),fluent.getSelector(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}