package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIServiceSpecFluentImpl<A extends APIServiceSpecFluent<A>> extends BaseFluent<A> implements APIServiceSpecFluent<A>{
  public APIServiceSpecFluentImpl() {
  }
  public APIServiceSpecFluentImpl(APIServiceSpec instance) {
    this.withCaBundle(instance.getCaBundle()); 
    this.withGroup(instance.getGroup()); 
    this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum()); 
    this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify()); 
    this.withService(instance.getService()); 
    this.withVersion(instance.getVersion()); 
    this.withVersionPriority(instance.getVersionPriority()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String caBundle;
  private String group;
  private Integer groupPriorityMinimum;
  private Boolean insecureSkipTLSVerify;
  private ServiceReferenceBuilder service;
  private String version;
  private Integer versionPriority;
  private Map<String,Object> additionalProperties;
  public String getCaBundle() {
    return this.caBundle;
  }
  public A withCaBundle(String caBundle) {
    this.caBundle=caBundle; return (A) this;
  }
  public Boolean hasCaBundle() {
    return this.caBundle != null;
  }
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public Boolean hasGroup() {
    return this.group != null;
  }
  public Integer getGroupPriorityMinimum() {
    return this.groupPriorityMinimum;
  }
  public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
    this.groupPriorityMinimum=groupPriorityMinimum; return (A) this;
  }
  public Boolean hasGroupPriorityMinimum() {
    return this.groupPriorityMinimum != null;
  }
  public Boolean getInsecureSkipTLSVerify() {
    return this.insecureSkipTLSVerify;
  }
  public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
    this.insecureSkipTLSVerify=insecureSkipTLSVerify; return (A) this;
  }
  public Boolean hasInsecureSkipTLSVerify() {
    return this.insecureSkipTLSVerify != null;
  }
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceReference getService() {
    return this.service!=null ?this.service.build():null;
  }
  public ServiceReference buildService() {
    return this.service!=null ?this.service.build():null;
  }
  public A withService(ServiceReference service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  public Boolean hasService() {
    return this.service != null;
  }
  public A withNewService(String name,String namespace,Integer port) {
    return (A)withService(new ServiceReference(name, namespace, port));
  }
  public APIServiceSpecFluent.ServiceNested<A> withNewService() {
    return new APIServiceSpecFluentImpl.ServiceNestedImpl();
  }
  public APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
    return new APIServiceSpecFluentImpl.ServiceNestedImpl(item);
  }
  public APIServiceSpecFluent.ServiceNested<A> editService() {
    return withNewServiceLike(getService());
  }
  public APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
    return withNewServiceLike(getService() != null ? getService(): new ServiceReferenceBuilder().build());
  }
  public APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
    return withNewServiceLike(getService() != null ? getService(): item);
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public Integer getVersionPriority() {
    return this.versionPriority;
  }
  public A withVersionPriority(Integer versionPriority) {
    this.versionPriority=versionPriority; return (A) this;
  }
  public Boolean hasVersionPriority() {
    return this.versionPriority != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIServiceSpecFluentImpl that = (APIServiceSpecFluentImpl) o;
    if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (groupPriorityMinimum != null ? !groupPriorityMinimum.equals(that.groupPriorityMinimum) :that.groupPriorityMinimum != null) return false;
    if (insecureSkipTLSVerify != null ? !insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) :that.insecureSkipTLSVerify != null) return false;
    if (service != null ? !service.equals(that.service) :that.service != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (versionPriority != null ? !versionPriority.equals(that.versionPriority) :that.versionPriority != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caBundle,  group,  groupPriorityMinimum,  insecureSkipTLSVerify,  service,  version,  versionPriority,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (groupPriorityMinimum != null) { sb.append("groupPriorityMinimum:"); sb.append(groupPriorityMinimum + ","); }
    if (insecureSkipTLSVerify != null) { sb.append("insecureSkipTLSVerify:"); sb.append(insecureSkipTLSVerify + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (versionPriority != null) { sb.append("versionPriority:"); sb.append(versionPriority + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withInsecureSkipTLSVerify() {
    return withInsecureSkipTLSVerify(true);
  }
  class ServiceNestedImpl<N> extends ServiceReferenceFluentImpl<APIServiceSpecFluent.ServiceNested<N>> implements APIServiceSpecFluent.ServiceNested<N>,Nested<N>{
    ServiceNestedImpl(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceNestedImpl() {
      this.builder = new ServiceReferenceBuilder(this);
    }
    ServiceReferenceBuilder builder;
    public N and() {
      return (N) APIServiceSpecFluentImpl.this.withService(builder.build());
    }
    public N endService() {
      return and();
    }
    
  }
  
}