package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ComponentStatusListFluent<A extends ComponentStatusListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ComponentStatus item);
  public A setToItems(Integer index,ComponentStatus item);
  public A addToItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public A addAllToItems(Collection<ComponentStatus> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public A removeAllFromItems(Collection<ComponentStatus> items);
  public A removeMatchingFromItems(Predicate<ComponentStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ComponentStatus> getItems();
  public List<ComponentStatus> buildItems();
  public ComponentStatus buildItem(Integer index);
  public ComponentStatus buildFirstItem();
  public ComponentStatus buildLastItem();
  public ComponentStatus buildMatchingItem(Predicate<ComponentStatusBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ComponentStatusBuilder> predicate);
  public A withItems(List<ComponentStatus> items);
  public A withItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public Boolean hasItems();
  public ComponentStatusListFluent.ItemsNested<A> addNewItem();
  public ComponentStatusListFluent.ItemsNested<A> addNewItemLike(ComponentStatus item);
  public ComponentStatusListFluent.ItemsNested<A> setNewItemLike(Integer index,ComponentStatus item);
  public ComponentStatusListFluent.ItemsNested<A> editItem(Integer index);
  public ComponentStatusListFluent.ItemsNested<A> editFirstItem();
  public ComponentStatusListFluent.ItemsNested<A> editLastItem();
  public ComponentStatusListFluent.ItemsNested<A> editMatchingItem(Predicate<ComponentStatusBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public ComponentStatusListFluent.MetadataNested<A> withNewMetadata();
  public ComponentStatusListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public ComponentStatusListFluent.MetadataNested<A> editMetadata();
  public ComponentStatusListFluent.MetadataNested<A> editOrNewMetadata();
  public ComponentStatusListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ComponentStatusFluent<ComponentStatusListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ComponentStatusListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}