package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToClusters(Integer index,NamedCluster item);
  public A setToClusters(Integer index,NamedCluster item);
  public A addToClusters(io.fabric8.kubernetes.api.model.NamedCluster... items);
  public A addAllToClusters(Collection<NamedCluster> items);
  public A removeFromClusters(io.fabric8.kubernetes.api.model.NamedCluster... items);
  public A removeAllFromClusters(Collection<NamedCluster> items);
  public A removeMatchingFromClusters(Predicate<NamedClusterBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedCluster> getClusters();
  public List<NamedCluster> buildClusters();
  public NamedCluster buildCluster(Integer index);
  public NamedCluster buildFirstCluster();
  public NamedCluster buildLastCluster();
  public NamedCluster buildMatchingCluster(Predicate<NamedClusterBuilder> predicate);
  public Boolean hasMatchingCluster(Predicate<NamedClusterBuilder> predicate);
  public A withClusters(List<NamedCluster> clusters);
  public A withClusters(io.fabric8.kubernetes.api.model.NamedCluster... clusters);
  public Boolean hasClusters();
  public ConfigFluent.ClustersNested<A> addNewCluster();
  public ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item);
  public ConfigFluent.ClustersNested<A> setNewClusterLike(Integer index,NamedCluster item);
  public ConfigFluent.ClustersNested<A> editCluster(Integer index);
  public ConfigFluent.ClustersNested<A> editFirstCluster();
  public ConfigFluent.ClustersNested<A> editLastCluster();
  public ConfigFluent.ClustersNested<A> editMatchingCluster(Predicate<NamedClusterBuilder> predicate);
  public A addToContexts(Integer index,NamedContext item);
  public A setToContexts(Integer index,NamedContext item);
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A addAllToContexts(Collection<NamedContext> items);
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items);
  public A removeAllFromContexts(Collection<NamedContext> items);
  public A removeMatchingFromContexts(Predicate<NamedContextBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContexts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedContext> getContexts();
  public List<NamedContext> buildContexts();
  public NamedContext buildContext(Integer index);
  public NamedContext buildFirstContext();
  public NamedContext buildLastContext();
  public NamedContext buildMatchingContext(Predicate<NamedContextBuilder> predicate);
  public Boolean hasMatchingContext(Predicate<NamedContextBuilder> predicate);
  public A withContexts(List<NamedContext> contexts);
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts);
  public Boolean hasContexts();
  public ConfigFluent.ContextsNested<A> addNewContext();
  public ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item);
  public ConfigFluent.ContextsNested<A> setNewContextLike(Integer index,NamedContext item);
  public ConfigFluent.ContextsNested<A> editContext(Integer index);
  public ConfigFluent.ContextsNested<A> editFirstContext();
  public ConfigFluent.ContextsNested<A> editLastContext();
  public ConfigFluent.ContextsNested<A> editMatchingContext(Predicate<NamedContextBuilder> predicate);
  public String getCurrentContext();
  public A withCurrentContext(String currentContext);
  public Boolean hasCurrentContext();
  public A addToExtensions(Integer index,NamedExtension item);
  public A setToExtensions(Integer index,NamedExtension item);
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items);
  public A addAllToExtensions(Collection<NamedExtension> items);
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items);
  public A removeAllFromExtensions(Collection<NamedExtension> items);
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedExtension> getExtensions();
  public List<NamedExtension> buildExtensions();
  public NamedExtension buildExtension(Integer index);
  public NamedExtension buildFirstExtension();
  public NamedExtension buildLastExtension();
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
  public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
  public A withExtensions(List<NamedExtension> extensions);
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions);
  public Boolean hasExtensions();
  public ConfigFluent.ExtensionsNested<A> addNewExtension();
  public ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item);
  public ConfigFluent.ExtensionsNested<A> setNewExtensionLike(Integer index,NamedExtension item);
  public ConfigFluent.ExtensionsNested<A> editExtension(Integer index);
  public ConfigFluent.ExtensionsNested<A> editFirstExtension();
  public ConfigFluent.ExtensionsNested<A> editLastExtension();
  public ConfigFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildPreferences instead.
   * @return The buildable object.
   */
  @Deprecated
  public Preferences getPreferences();
  public Preferences buildPreferences();
  public A withPreferences(Preferences preferences);
  public Boolean hasPreferences();
  public ConfigFluent.PreferencesNested<A> withNewPreferences();
  public ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item);
  public ConfigFluent.PreferencesNested<A> editPreferences();
  public ConfigFluent.PreferencesNested<A> editOrNewPreferences();
  public ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(Preferences item);
  public A addToUsers(Integer index,NamedAuthInfo item);
  public A setToUsers(Integer index,NamedAuthInfo item);
  public A addToUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items);
  public A addAllToUsers(Collection<NamedAuthInfo> items);
  public A removeFromUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items);
  public A removeAllFromUsers(Collection<NamedAuthInfo> items);
  public A removeMatchingFromUsers(Predicate<NamedAuthInfoBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildUsers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedAuthInfo> getUsers();
  public List<NamedAuthInfo> buildUsers();
  public NamedAuthInfo buildUser(Integer index);
  public NamedAuthInfo buildFirstUser();
  public NamedAuthInfo buildLastUser();
  public NamedAuthInfo buildMatchingUser(Predicate<NamedAuthInfoBuilder> predicate);
  public Boolean hasMatchingUser(Predicate<NamedAuthInfoBuilder> predicate);
  public A withUsers(List<NamedAuthInfo> users);
  public A withUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... users);
  public Boolean hasUsers();
  public ConfigFluent.UsersNested<A> addNewUser();
  public ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item);
  public ConfigFluent.UsersNested<A> setNewUserLike(Integer index,NamedAuthInfo item);
  public ConfigFluent.UsersNested<A> editUser(Integer index);
  public ConfigFluent.UsersNested<A> editFirstUser();
  public ConfigFluent.UsersNested<A> editLastUser();
  public ConfigFluent.UsersNested<A> editMatchingUser(Predicate<NamedAuthInfoBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ClustersNested<N> extends Nested<N>,NamedClusterFluent<ConfigFluent.ClustersNested<N>>{
    public N and();
    public N endCluster();
    
  }
  public interface ContextsNested<N> extends Nested<N>,NamedContextFluent<ConfigFluent.ContextsNested<N>>{
    public N and();
    public N endContext();
    
  }
  public interface ExtensionsNested<N> extends Nested<N>,NamedExtensionFluent<ConfigFluent.ExtensionsNested<N>>{
    public N and();
    public N endExtension();
    
  }
  public interface PreferencesNested<N> extends Nested<N>,PreferencesFluent<ConfigFluent.PreferencesNested<N>>{
    public N and();
    public N endPreferences();
    
  }
  public interface UsersNested<N> extends Nested<N>,NamedAuthInfoFluent<ConfigFluent.UsersNested<N>>{
    public N and();
    public N endUser();
    
  }
  
}