package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigFluentImpl<A extends ConfigFluent<A>> extends BaseFluent<A> implements ConfigFluent<A>{
  public ConfigFluentImpl() {
  }
  public ConfigFluentImpl(Config instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withClusters(instance.getClusters()); 
    this.withContexts(instance.getContexts()); 
    this.withCurrentContext(instance.getCurrentContext()); 
    this.withExtensions(instance.getExtensions()); 
    this.withKind(instance.getKind()); 
    this.withPreferences(instance.getPreferences()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ArrayList<NamedClusterBuilder> clusters = new ArrayList<NamedClusterBuilder>();
  private ArrayList<NamedContextBuilder> contexts = new ArrayList<NamedContextBuilder>();
  private String currentContext;
  private ArrayList<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
  private String kind;
  private PreferencesBuilder preferences;
  private ArrayList<NamedAuthInfoBuilder> users = new ArrayList<NamedAuthInfoBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToClusters(Integer index,NamedCluster item) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").add(index >= 0 ? index : _visitables.get("clusters").size(), builder);this.clusters.add(index >= 0 ? index : clusters.size(), builder); return (A)this;
  }
  public A setToClusters(Integer index,NamedCluster item) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    NamedClusterBuilder builder = new NamedClusterBuilder(item);
    if (index < 0 || index >= _visitables.get("clusters").size()) { _visitables.get("clusters").add(builder); } else { _visitables.get("clusters").set(index, builder);}
    if (index < 0 || index >= clusters.size()) { clusters.add(builder); } else { clusters.set(index, builder);}
     return (A)this;
  }
  public A addToClusters(io.fabric8.kubernetes.api.model.NamedCluster... items) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A addAllToClusters(Collection<NamedCluster> items) {
    if (this.clusters == null) {this.clusters = new ArrayList<NamedClusterBuilder>();}
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").add(builder);this.clusters.add(builder);} return (A)this;
  }
  public A removeFromClusters(io.fabric8.kubernetes.api.model.NamedCluster... items) {
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusters(Collection<NamedCluster> items) {
    for (NamedCluster item : items) {NamedClusterBuilder builder = new NamedClusterBuilder(item);_visitables.get("clusters").remove(builder);if (this.clusters != null) {this.clusters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusters(Predicate<NamedClusterBuilder> predicate) {
    if (clusters == null) return (A) this;
    final Iterator<NamedClusterBuilder> each = clusters.iterator();
    final List visitables = _visitables.get("clusters");
    while (each.hasNext()) {
      NamedClusterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedCluster> getClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public List<NamedCluster> buildClusters() {
    return clusters != null ? build(clusters) : null;
  }
  public NamedCluster buildCluster(Integer index) {
    return this.clusters.get(index).build();
  }
  public NamedCluster buildFirstCluster() {
    return this.clusters.get(0).build();
  }
  public NamedCluster buildLastCluster() {
    return this.clusters.get(clusters.size() - 1).build();
  }
  public NamedCluster buildMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
    for (NamedClusterBuilder item: clusters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
    for (NamedClusterBuilder item: clusters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusters(List<NamedCluster> clusters) {
    if (this.clusters != null) { _visitables.get("clusters").removeAll(this.clusters);}
    if (clusters != null) {this.clusters = new ArrayList(); for (NamedCluster item : clusters){this.addToClusters(item);}} else { this.clusters = null;} return (A) this;
  }
  public A withClusters(io.fabric8.kubernetes.api.model.NamedCluster... clusters) {
    if (this.clusters != null) {this.clusters.clear();}
    if (clusters != null) {for (NamedCluster item :clusters){ this.addToClusters(item);}} return (A) this;
  }
  public Boolean hasClusters() {
    return clusters != null && !clusters.isEmpty();
  }
  public ConfigFluent.ClustersNested<A> addNewCluster() {
    return new ConfigFluentImpl.ClustersNestedImpl();
  }
  public ConfigFluent.ClustersNested<A> addNewClusterLike(NamedCluster item) {
    return new ConfigFluentImpl.ClustersNestedImpl(-1, item);
  }
  public ConfigFluent.ClustersNested<A> setNewClusterLike(Integer index,NamedCluster item) {
    return new ConfigFluentImpl.ClustersNestedImpl(index, item);
  }
  public ConfigFluent.ClustersNested<A> editCluster(Integer index) {
    if (clusters.size() <= index) throw new RuntimeException("Can't edit clusters. Index exceeds size.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public ConfigFluent.ClustersNested<A> editFirstCluster() {
    if (clusters.size() == 0) throw new RuntimeException("Can't edit first clusters. The list is empty.");
    return setNewClusterLike(0, buildCluster(0));
  }
  public ConfigFluent.ClustersNested<A> editLastCluster() {
    int index = clusters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusters. The list is empty.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public ConfigFluent.ClustersNested<A> editMatchingCluster(Predicate<NamedClusterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusters.size();i++) { 
    if (predicate.test(clusters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusters. No match found.");
    return setNewClusterLike(index, buildCluster(index));
  }
  public A addToContexts(Integer index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").add(index >= 0 ? index : _visitables.get("contexts").size(), builder);this.contexts.add(index >= 0 ? index : contexts.size(), builder); return (A)this;
  }
  public A setToContexts(Integer index,NamedContext item) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    NamedContextBuilder builder = new NamedContextBuilder(item);
    if (index < 0 || index >= _visitables.get("contexts").size()) { _visitables.get("contexts").add(builder); } else { _visitables.get("contexts").set(index, builder);}
    if (index < 0 || index >= contexts.size()) { contexts.add(builder); } else { contexts.set(index, builder);}
     return (A)this;
  }
  public A addToContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").add(builder);this.contexts.add(builder);} return (A)this;
  }
  public A addAllToContexts(Collection<NamedContext> items) {
    if (this.contexts == null) {this.contexts = new ArrayList<NamedContextBuilder>();}
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").add(builder);this.contexts.add(builder);} return (A)this;
  }
  public A removeFromContexts(io.fabric8.kubernetes.api.model.NamedContext... items) {
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").remove(builder);if (this.contexts != null) {this.contexts.remove(builder);}} return (A)this;
  }
  public A removeAllFromContexts(Collection<NamedContext> items) {
    for (NamedContext item : items) {NamedContextBuilder builder = new NamedContextBuilder(item);_visitables.get("contexts").remove(builder);if (this.contexts != null) {this.contexts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContexts(Predicate<NamedContextBuilder> predicate) {
    if (contexts == null) return (A) this;
    final Iterator<NamedContextBuilder> each = contexts.iterator();
    final List visitables = _visitables.get("contexts");
    while (each.hasNext()) {
      NamedContextBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContexts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedContext> getContexts() {
    return contexts != null ? build(contexts) : null;
  }
  public List<NamedContext> buildContexts() {
    return contexts != null ? build(contexts) : null;
  }
  public NamedContext buildContext(Integer index) {
    return this.contexts.get(index).build();
  }
  public NamedContext buildFirstContext() {
    return this.contexts.get(0).build();
  }
  public NamedContext buildLastContext() {
    return this.contexts.get(contexts.size() - 1).build();
  }
  public NamedContext buildMatchingContext(Predicate<NamedContextBuilder> predicate) {
    for (NamedContextBuilder item: contexts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContext(Predicate<NamedContextBuilder> predicate) {
    for (NamedContextBuilder item: contexts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContexts(List<NamedContext> contexts) {
    if (this.contexts != null) { _visitables.get("contexts").removeAll(this.contexts);}
    if (contexts != null) {this.contexts = new ArrayList(); for (NamedContext item : contexts){this.addToContexts(item);}} else { this.contexts = null;} return (A) this;
  }
  public A withContexts(io.fabric8.kubernetes.api.model.NamedContext... contexts) {
    if (this.contexts != null) {this.contexts.clear();}
    if (contexts != null) {for (NamedContext item :contexts){ this.addToContexts(item);}} return (A) this;
  }
  public Boolean hasContexts() {
    return contexts != null && !contexts.isEmpty();
  }
  public ConfigFluent.ContextsNested<A> addNewContext() {
    return new ConfigFluentImpl.ContextsNestedImpl();
  }
  public ConfigFluent.ContextsNested<A> addNewContextLike(NamedContext item) {
    return new ConfigFluentImpl.ContextsNestedImpl(-1, item);
  }
  public ConfigFluent.ContextsNested<A> setNewContextLike(Integer index,NamedContext item) {
    return new ConfigFluentImpl.ContextsNestedImpl(index, item);
  }
  public ConfigFluent.ContextsNested<A> editContext(Integer index) {
    if (contexts.size() <= index) throw new RuntimeException("Can't edit contexts. Index exceeds size.");
    return setNewContextLike(index, buildContext(index));
  }
  public ConfigFluent.ContextsNested<A> editFirstContext() {
    if (contexts.size() == 0) throw new RuntimeException("Can't edit first contexts. The list is empty.");
    return setNewContextLike(0, buildContext(0));
  }
  public ConfigFluent.ContextsNested<A> editLastContext() {
    int index = contexts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last contexts. The list is empty.");
    return setNewContextLike(index, buildContext(index));
  }
  public ConfigFluent.ContextsNested<A> editMatchingContext(Predicate<NamedContextBuilder> predicate) {
    int index = -1;
    for (int i=0;i<contexts.size();i++) { 
    if (predicate.test(contexts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching contexts. No match found.");
    return setNewContextLike(index, buildContext(index));
  }
  public String getCurrentContext() {
    return this.currentContext;
  }
  public A withCurrentContext(String currentContext) {
    this.currentContext=currentContext; return (A) this;
  }
  public Boolean hasCurrentContext() {
    return this.currentContext != null;
  }
  public A addToExtensions(Integer index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(index >= 0 ? index : _visitables.get("extensions").size(), builder);this.extensions.add(index >= 0 ? index : extensions.size(), builder); return (A)this;
  }
  public A setToExtensions(Integer index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= _visitables.get("extensions").size()) { _visitables.get("extensions").add(builder); } else { _visitables.get("extensions").set(index, builder);}
    if (index < 0 || index >= extensions.size()) { extensions.add(builder); } else { extensions.set(index, builder);}
     return (A)this;
  }
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A addAllToExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtensions(Collection<NamedExtension> items) {
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder);if (this.extensions != null) {this.extensions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtensions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedExtension> getExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public List<NamedExtension> buildExtensions() {
    return extensions != null ? build(extensions) : null;
  }
  public NamedExtension buildExtension(Integer index) {
    return this.extensions.get(index).build();
  }
  public NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  public NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    for (NamedExtensionBuilder item: extensions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtensions(List<NamedExtension> extensions) {
    if (this.extensions != null) { _visitables.get("extensions").removeAll(this.extensions);}
    if (extensions != null) {this.extensions = new ArrayList(); for (NamedExtension item : extensions){this.addToExtensions(item);}} else { this.extensions = null;} return (A) this;
  }
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {this.extensions.clear();}
    if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
  }
  public Boolean hasExtensions() {
    return extensions != null && !extensions.isEmpty();
  }
  public ConfigFluent.ExtensionsNested<A> addNewExtension() {
    return new ConfigFluentImpl.ExtensionsNestedImpl();
  }
  public ConfigFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
    return new ConfigFluentImpl.ExtensionsNestedImpl(-1, item);
  }
  public ConfigFluent.ExtensionsNested<A> setNewExtensionLike(Integer index,NamedExtension item) {
    return new ConfigFluentImpl.ExtensionsNestedImpl(index, item);
  }
  public ConfigFluent.ExtensionsNested<A> editExtension(Integer index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public ConfigFluent.ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public ConfigFluent.ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public ConfigFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPreferences instead.
   * @return The buildable object.
   */
  @Deprecated
  public Preferences getPreferences() {
    return this.preferences!=null ?this.preferences.build():null;
  }
  public Preferences buildPreferences() {
    return this.preferences!=null ?this.preferences.build():null;
  }
  public A withPreferences(Preferences preferences) {
    _visitables.get("preferences").remove(this.preferences);
    if (preferences!=null){ this.preferences= new PreferencesBuilder(preferences); _visitables.get("preferences").add(this.preferences);} else { this.preferences = null; _visitables.get("preferences").remove(this.preferences); } return (A) this;
  }
  public Boolean hasPreferences() {
    return this.preferences != null;
  }
  public ConfigFluent.PreferencesNested<A> withNewPreferences() {
    return new ConfigFluentImpl.PreferencesNestedImpl();
  }
  public ConfigFluent.PreferencesNested<A> withNewPreferencesLike(Preferences item) {
    return new ConfigFluentImpl.PreferencesNestedImpl(item);
  }
  public ConfigFluent.PreferencesNested<A> editPreferences() {
    return withNewPreferencesLike(getPreferences());
  }
  public ConfigFluent.PreferencesNested<A> editOrNewPreferences() {
    return withNewPreferencesLike(getPreferences() != null ? getPreferences(): new PreferencesBuilder().build());
  }
  public ConfigFluent.PreferencesNested<A> editOrNewPreferencesLike(Preferences item) {
    return withNewPreferencesLike(getPreferences() != null ? getPreferences(): item);
  }
  public A addToUsers(Integer index,NamedAuthInfo item) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").add(index >= 0 ? index : _visitables.get("users").size(), builder);this.users.add(index >= 0 ? index : users.size(), builder); return (A)this;
  }
  public A setToUsers(Integer index,NamedAuthInfo item) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);
    if (index < 0 || index >= _visitables.get("users").size()) { _visitables.get("users").add(builder); } else { _visitables.get("users").set(index, builder);}
    if (index < 0 || index >= users.size()) { users.add(builder); } else { users.set(index, builder);}
     return (A)this;
  }
  public A addToUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").add(builder);this.users.add(builder);} return (A)this;
  }
  public A addAllToUsers(Collection<NamedAuthInfo> items) {
    if (this.users == null) {this.users = new ArrayList<NamedAuthInfoBuilder>();}
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").add(builder);this.users.add(builder);} return (A)this;
  }
  public A removeFromUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... items) {
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").remove(builder);if (this.users != null) {this.users.remove(builder);}} return (A)this;
  }
  public A removeAllFromUsers(Collection<NamedAuthInfo> items) {
    for (NamedAuthInfo item : items) {NamedAuthInfoBuilder builder = new NamedAuthInfoBuilder(item);_visitables.get("users").remove(builder);if (this.users != null) {this.users.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromUsers(Predicate<NamedAuthInfoBuilder> predicate) {
    if (users == null) return (A) this;
    final Iterator<NamedAuthInfoBuilder> each = users.iterator();
    final List visitables = _visitables.get("users");
    while (each.hasNext()) {
      NamedAuthInfoBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildUsers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedAuthInfo> getUsers() {
    return users != null ? build(users) : null;
  }
  public List<NamedAuthInfo> buildUsers() {
    return users != null ? build(users) : null;
  }
  public NamedAuthInfo buildUser(Integer index) {
    return this.users.get(index).build();
  }
  public NamedAuthInfo buildFirstUser() {
    return this.users.get(0).build();
  }
  public NamedAuthInfo buildLastUser() {
    return this.users.get(users.size() - 1).build();
  }
  public NamedAuthInfo buildMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
    for (NamedAuthInfoBuilder item: users) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
    for (NamedAuthInfoBuilder item: users) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsers(List<NamedAuthInfo> users) {
    if (this.users != null) { _visitables.get("users").removeAll(this.users);}
    if (users != null) {this.users = new ArrayList(); for (NamedAuthInfo item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
  }
  public A withUsers(io.fabric8.kubernetes.api.model.NamedAuthInfo... users) {
    if (this.users != null) {this.users.clear();}
    if (users != null) {for (NamedAuthInfo item :users){ this.addToUsers(item);}} return (A) this;
  }
  public Boolean hasUsers() {
    return users != null && !users.isEmpty();
  }
  public ConfigFluent.UsersNested<A> addNewUser() {
    return new ConfigFluentImpl.UsersNestedImpl();
  }
  public ConfigFluent.UsersNested<A> addNewUserLike(NamedAuthInfo item) {
    return new ConfigFluentImpl.UsersNestedImpl(-1, item);
  }
  public ConfigFluent.UsersNested<A> setNewUserLike(Integer index,NamedAuthInfo item) {
    return new ConfigFluentImpl.UsersNestedImpl(index, item);
  }
  public ConfigFluent.UsersNested<A> editUser(Integer index) {
    if (users.size() <= index) throw new RuntimeException("Can't edit users. Index exceeds size.");
    return setNewUserLike(index, buildUser(index));
  }
  public ConfigFluent.UsersNested<A> editFirstUser() {
    if (users.size() == 0) throw new RuntimeException("Can't edit first users. The list is empty.");
    return setNewUserLike(0, buildUser(0));
  }
  public ConfigFluent.UsersNested<A> editLastUser() {
    int index = users.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last users. The list is empty.");
    return setNewUserLike(index, buildUser(index));
  }
  public ConfigFluent.UsersNested<A> editMatchingUser(Predicate<NamedAuthInfoBuilder> predicate) {
    int index = -1;
    for (int i=0;i<users.size();i++) { 
    if (predicate.test(users.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching users. No match found.");
    return setNewUserLike(index, buildUser(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigFluentImpl that = (ConfigFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (clusters != null ? !clusters.equals(that.clusters) :that.clusters != null) return false;
    if (contexts != null ? !contexts.equals(that.contexts) :that.contexts != null) return false;
    if (currentContext != null ? !currentContext.equals(that.currentContext) :that.currentContext != null) return false;
    if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (preferences != null ? !preferences.equals(that.preferences) :that.preferences != null) return false;
    if (users != null ? !users.equals(that.users) :that.users != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  clusters,  contexts,  currentContext,  extensions,  kind,  preferences,  users,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (clusters != null && !clusters.isEmpty()) { sb.append("clusters:"); sb.append(clusters + ","); }
    if (contexts != null && !contexts.isEmpty()) { sb.append("contexts:"); sb.append(contexts + ","); }
    if (currentContext != null) { sb.append("currentContext:"); sb.append(currentContext + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (preferences != null) { sb.append("preferences:"); sb.append(preferences + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClustersNestedImpl<N> extends NamedClusterFluentImpl<ConfigFluent.ClustersNested<N>> implements ConfigFluent.ClustersNested<N>,Nested<N>{
    ClustersNestedImpl(Integer index,NamedCluster item) {
      this.index = index;
      this.builder = new NamedClusterBuilder(this, item);
    }
    ClustersNestedImpl() {
      this.index = -1;
      this.builder = new NamedClusterBuilder(this);
    }
    NamedClusterBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToClusters(index,builder.build());
    }
    public N endCluster() {
      return and();
    }
    
  }
  class ContextsNestedImpl<N> extends NamedContextFluentImpl<ConfigFluent.ContextsNested<N>> implements ConfigFluent.ContextsNested<N>,Nested<N>{
    ContextsNestedImpl(Integer index,NamedContext item) {
      this.index = index;
      this.builder = new NamedContextBuilder(this, item);
    }
    ContextsNestedImpl() {
      this.index = -1;
      this.builder = new NamedContextBuilder(this);
    }
    NamedContextBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToContexts(index,builder.build());
    }
    public N endContext() {
      return and();
    }
    
  }
  class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ConfigFluent.ExtensionsNested<N>> implements ConfigFluent.ExtensionsNested<N>,Nested<N>{
    ExtensionsNestedImpl(Integer index,NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    ExtensionsNestedImpl() {
      this.index = -1;
      this.builder = new NamedExtensionBuilder(this);
    }
    NamedExtensionBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToExtensions(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  class PreferencesNestedImpl<N> extends PreferencesFluentImpl<ConfigFluent.PreferencesNested<N>> implements ConfigFluent.PreferencesNested<N>,Nested<N>{
    PreferencesNestedImpl(Preferences item) {
      this.builder = new PreferencesBuilder(this, item);
    }
    PreferencesNestedImpl() {
      this.builder = new PreferencesBuilder(this);
    }
    PreferencesBuilder builder;
    public N and() {
      return (N) ConfigFluentImpl.this.withPreferences(builder.build());
    }
    public N endPreferences() {
      return and();
    }
    
  }
  class UsersNestedImpl<N> extends NamedAuthInfoFluentImpl<ConfigFluent.UsersNested<N>> implements ConfigFluent.UsersNested<N>,Nested<N>{
    UsersNestedImpl(Integer index,NamedAuthInfo item) {
      this.index = index;
      this.builder = new NamedAuthInfoBuilder(this, item);
    }
    UsersNestedImpl() {
      this.index = -1;
      this.builder = new NamedAuthInfoBuilder(this);
    }
    NamedAuthInfoBuilder builder;
    Integer index;
    public N and() {
      return (N) ConfigFluentImpl.this.setToUsers(index,builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}