package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EphemeralContainerFluentImpl<A extends EphemeralContainerFluent<A>> extends BaseFluent<A> implements EphemeralContainerFluent<A>{
  public EphemeralContainerFluentImpl() {
  }
  public EphemeralContainerFluentImpl(EphemeralContainer instance) {
    this.withArgs(instance.getArgs()); 
    this.withCommand(instance.getCommand()); 
    this.withEnv(instance.getEnv()); 
    this.withEnvFrom(instance.getEnvFrom()); 
    this.withImage(instance.getImage()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withLifecycle(instance.getLifecycle()); 
    this.withLivenessProbe(instance.getLivenessProbe()); 
    this.withName(instance.getName()); 
    this.withPorts(instance.getPorts()); 
    this.withReadinessProbe(instance.getReadinessProbe()); 
    this.withResources(instance.getResources()); 
    this.withSecurityContext(instance.getSecurityContext()); 
    this.withStartupProbe(instance.getStartupProbe()); 
    this.withStdin(instance.getStdin()); 
    this.withStdinOnce(instance.getStdinOnce()); 
    this.withTargetContainerName(instance.getTargetContainerName()); 
    this.withTerminationMessagePath(instance.getTerminationMessagePath()); 
    this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy()); 
    this.withTty(instance.getTty()); 
    this.withVolumeDevices(instance.getVolumeDevices()); 
    this.withVolumeMounts(instance.getVolumeMounts()); 
    this.withWorkingDir(instance.getWorkingDir()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> args = new ArrayList<String>();
  private List<String> command = new ArrayList<String>();
  private ArrayList<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
  private ArrayList<EnvFromSourceBuilder> envFrom = new ArrayList<EnvFromSourceBuilder>();
  private String image;
  private String imagePullPolicy;
  private LifecycleBuilder lifecycle;
  private ProbeBuilder livenessProbe;
  private String name;
  private ArrayList<ContainerPortBuilder> ports = new ArrayList<ContainerPortBuilder>();
  private ProbeBuilder readinessProbe;
  private ResourceRequirementsBuilder resources;
  private SecurityContextBuilder securityContext;
  private ProbeBuilder startupProbe;
  private Boolean stdin;
  private Boolean stdinOnce;
  private String targetContainerName;
  private String terminationMessagePath;
  private String terminationMessagePolicy;
  private Boolean tty;
  private ArrayList<VolumeDeviceBuilder> volumeDevices = new ArrayList<VolumeDeviceBuilder>();
  private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList<VolumeMountBuilder>();
  private String workingDir;
  private Map<String,Object> additionalProperties;
  public A addToArgs(Integer index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.add(index, item);
    return (A)this;
  }
  public A setToArgs(Integer index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.set(index, item); return (A)this;
  }
  public A addToArgs(java.lang.String... items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  public A addAllToArgs(Collection<String> items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  public A removeFromArgs(java.lang.String... items) {
    for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public A removeAllFromArgs(Collection<String> items) {
    for (String item : items) {if (this.args!= null){ this.args.remove(item);}} return (A)this;
  }
  public List<String> getArgs() {
    return this.args;
  }
  public String getArg(Integer index) {
    return this.args.get(index);
  }
  public String getFirstArg() {
    return this.args.get(0);
  }
  public String getLastArg() {
    return this.args.get(args.size() - 1);
  }
  public String getMatchingArg(Predicate<String> predicate) {
    for (String item: args) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingArg(Predicate<String> predicate) {
    for (String item: args) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArgs(List<String> args) {
    if (args != null) {this.args = new ArrayList(); for (String item : args){this.addToArgs(item);}} else { this.args = null;} return (A) this;
  }
  public A withArgs(java.lang.String... args) {
    if (this.args != null) {this.args.clear();}
    if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
  }
  public Boolean hasArgs() {
    return args != null && !args.isEmpty();
  }
  public A addToCommand(Integer index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  public A setToCommand(Integer index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  public A removeFromCommand(java.lang.String... items) {
    for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public A removeAllFromCommand(Collection<String> items) {
    for (String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public List<String> getCommand() {
    return this.command;
  }
  public String getCommand(Integer index) {
    return this.command.get(index);
  }
  public String getFirstCommand() {
    return this.command.get(0);
  }
  public String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  public String getMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCommand(Predicate<String> predicate) {
    for (String item: command) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCommand(List<String> command) {
    if (command != null) {this.command = new ArrayList(); for (String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
  }
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {this.command.clear();}
    if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
  }
  public Boolean hasCommand() {
    return command != null && !command.isEmpty();
  }
  public A addToEnv(Integer index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
  }
  public A setToEnv(Integer index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    EnvVarBuilder builder = new EnvVarBuilder(item);
    if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
    if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
     return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVarBuilder>();}
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeAllFromEnv(Collection<EnvVar> items) {
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
    if (env == null) return (A) this;
    final Iterator<EnvVarBuilder> each = env.iterator();
    final List visitables = _visitables.get("env");
    while (each.hasNext()) {
      EnvVarBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EnvVar> getEnv() {
    return env != null ? build(env) : null;
  }
  public List<EnvVar> buildEnv() {
    return env != null ? build(env) : null;
  }
  public EnvVar buildEnv(Integer index) {
    return this.env.get(index).build();
  }
  public EnvVar buildFirstEnv() {
    return this.env.get(0).build();
  }
  public EnvVar buildLastEnv() {
    return this.env.get(env.size() - 1).build();
  }
  public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    for (EnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    for (EnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(List<EnvVar> env) {
    if (this.env != null) { _visitables.get("env").removeAll(this.env);}
    if (env != null) {this.env = new ArrayList(); for (EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public EphemeralContainerFluent.EnvNested<A> addNewEnv() {
    return new EphemeralContainerFluentImpl.EnvNestedImpl();
  }
  public EphemeralContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
    return new EphemeralContainerFluentImpl.EnvNestedImpl(-1, item);
  }
  public EphemeralContainerFluent.EnvNested<A> setNewEnvLike(Integer index,EnvVar item) {
    return new EphemeralContainerFluentImpl.EnvNestedImpl(index, item);
  }
  public EphemeralContainerFluent.EnvNested<A> editEnv(Integer index) {
    if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public EphemeralContainerFluent.EnvNested<A> editFirstEnv() {
    if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
    return setNewEnvLike(0, buildEnv(0));
  }
  public EphemeralContainerFluent.EnvNested<A> editLastEnv() {
    int index = env.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public EphemeralContainerFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
    int index = -1;
    for (int i=0;i<env.size();i++) { 
    if (predicate.test(env.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
    return setNewEnvLike(index, buildEnv(index));
  }
  public A addToEnvFrom(Integer index,EnvFromSource item) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSourceBuilder>();}
    EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);_visitables.get("envFrom").add(index >= 0 ? index : _visitables.get("envFrom").size(), builder);this.envFrom.add(index >= 0 ? index : envFrom.size(), builder); return (A)this;
  }
  public A setToEnvFrom(Integer index,EnvFromSource item) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSourceBuilder>();}
    EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
    if (index < 0 || index >= _visitables.get("envFrom").size()) { _visitables.get("envFrom").add(builder); } else { _visitables.get("envFrom").set(index, builder);}
    if (index < 0 || index >= envFrom.size()) { envFrom.add(builder); } else { envFrom.set(index, builder);}
     return (A)this;
  }
  public A addToEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSourceBuilder>();}
    for (EnvFromSource item : items) {EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
  }
  public A addAllToEnvFrom(Collection<EnvFromSource> items) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSourceBuilder>();}
    for (EnvFromSource item : items) {EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);_visitables.get("envFrom").add(builder);this.envFrom.add(builder);} return (A)this;
  }
  public A removeFromEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
    for (EnvFromSource item : items) {EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
  }
  public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
    for (EnvFromSource item : items) {EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);_visitables.get("envFrom").remove(builder);if (this.envFrom != null) {this.envFrom.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
    if (envFrom == null) return (A) this;
    final Iterator<EnvFromSourceBuilder> each = envFrom.iterator();
    final List visitables = _visitables.get("envFrom");
    while (each.hasNext()) {
      EnvFromSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEnvFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EnvFromSource> getEnvFrom() {
    return envFrom != null ? build(envFrom) : null;
  }
  public List<EnvFromSource> buildEnvFrom() {
    return envFrom != null ? build(envFrom) : null;
  }
  public EnvFromSource buildEnvFrom(Integer index) {
    return this.envFrom.get(index).build();
  }
  public EnvFromSource buildFirstEnvFrom() {
    return this.envFrom.get(0).build();
  }
  public EnvFromSource buildLastEnvFrom() {
    return this.envFrom.get(envFrom.size() - 1).build();
  }
  public EnvFromSource buildMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
    for (EnvFromSourceBuilder item: envFrom) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
    for (EnvFromSourceBuilder item: envFrom) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnvFrom(List<EnvFromSource> envFrom) {
    if (this.envFrom != null) { _visitables.get("envFrom").removeAll(this.envFrom);}
    if (envFrom != null) {this.envFrom = new ArrayList(); for (EnvFromSource item : envFrom){this.addToEnvFrom(item);}} else { this.envFrom = null;} return (A) this;
  }
  public A withEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... envFrom) {
    if (this.envFrom != null) {this.envFrom.clear();}
    if (envFrom != null) {for (EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
  }
  public Boolean hasEnvFrom() {
    return envFrom != null && !envFrom.isEmpty();
  }
  public EphemeralContainerFluent.EnvFromNested<A> addNewEnvFrom() {
    return new EphemeralContainerFluentImpl.EnvFromNestedImpl();
  }
  public EphemeralContainerFluent.EnvFromNested<A> addNewEnvFromLike(EnvFromSource item) {
    return new EphemeralContainerFluentImpl.EnvFromNestedImpl(-1, item);
  }
  public EphemeralContainerFluent.EnvFromNested<A> setNewEnvFromLike(Integer index,EnvFromSource item) {
    return new EphemeralContainerFluentImpl.EnvFromNestedImpl(index, item);
  }
  public EphemeralContainerFluent.EnvFromNested<A> editEnvFrom(Integer index) {
    if (envFrom.size() <= index) throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
    return setNewEnvFromLike(index, buildEnvFrom(index));
  }
  public EphemeralContainerFluent.EnvFromNested<A> editFirstEnvFrom() {
    if (envFrom.size() == 0) throw new RuntimeException("Can't edit first envFrom. The list is empty.");
    return setNewEnvFromLike(0, buildEnvFrom(0));
  }
  public EphemeralContainerFluent.EnvFromNested<A> editLastEnvFrom() {
    int index = envFrom.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last envFrom. The list is empty.");
    return setNewEnvFromLike(index, buildEnvFrom(index));
  }
  public EphemeralContainerFluent.EnvFromNested<A> editMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<envFrom.size();i++) { 
    if (predicate.test(envFrom.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching envFrom. No match found.");
    return setNewEnvFromLike(index, buildEnvFrom(index));
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getImagePullPolicy() {
    return this.imagePullPolicy;
  }
  public A withImagePullPolicy(String imagePullPolicy) {
    this.imagePullPolicy=imagePullPolicy; return (A) this;
  }
  public Boolean hasImagePullPolicy() {
    return this.imagePullPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLifecycle instead.
   * @return The buildable object.
   */
  @Deprecated
  public Lifecycle getLifecycle() {
    return this.lifecycle!=null ?this.lifecycle.build():null;
  }
  public Lifecycle buildLifecycle() {
    return this.lifecycle!=null ?this.lifecycle.build():null;
  }
  public A withLifecycle(Lifecycle lifecycle) {
    _visitables.get("lifecycle").remove(this.lifecycle);
    if (lifecycle!=null){ this.lifecycle= new LifecycleBuilder(lifecycle); _visitables.get("lifecycle").add(this.lifecycle);} else { this.lifecycle = null; _visitables.get("lifecycle").remove(this.lifecycle); } return (A) this;
  }
  public Boolean hasLifecycle() {
    return this.lifecycle != null;
  }
  public EphemeralContainerFluent.LifecycleNested<A> withNewLifecycle() {
    return new EphemeralContainerFluentImpl.LifecycleNestedImpl();
  }
  public EphemeralContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item) {
    return new EphemeralContainerFluentImpl.LifecycleNestedImpl(item);
  }
  public EphemeralContainerFluent.LifecycleNested<A> editLifecycle() {
    return withNewLifecycleLike(getLifecycle());
  }
  public EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycle() {
    return withNewLifecycleLike(getLifecycle() != null ? getLifecycle(): new LifecycleBuilder().build());
  }
  public EphemeralContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item) {
    return withNewLifecycleLike(getLifecycle() != null ? getLifecycle(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLivenessProbe instead.
   * @return The buildable object.
   */
  @Deprecated
  public Probe getLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public Probe buildLivenessProbe() {
    return this.livenessProbe!=null ?this.livenessProbe.build():null;
  }
  public A withLivenessProbe(Probe livenessProbe) {
    _visitables.get("livenessProbe").remove(this.livenessProbe);
    if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} else { this.livenessProbe = null; _visitables.get("livenessProbe").remove(this.livenessProbe); } return (A) this;
  }
  public Boolean hasLivenessProbe() {
    return this.livenessProbe != null;
  }
  public EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbe() {
    return new EphemeralContainerFluentImpl.LivenessProbeNestedImpl();
  }
  public EphemeralContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
    return new EphemeralContainerFluentImpl.LivenessProbeNestedImpl(item);
  }
  public EphemeralContainerFluent.LivenessProbeNested<A> editLivenessProbe() {
    return withNewLivenessProbeLike(getLivenessProbe());
  }
  public EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
    return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
  }
  public EphemeralContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
    return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToPorts(Integer index,ContainerPort item) {
    if (this.ports == null) {this.ports = new ArrayList<ContainerPortBuilder>();}
    ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(Integer index,ContainerPort item) {
    if (this.ports == null) {this.ports = new ArrayList<ContainerPortBuilder>();}
    ContainerPortBuilder builder = new ContainerPortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.ContainerPort... items) {
    if (this.ports == null) {this.ports = new ArrayList<ContainerPortBuilder>();}
    for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<ContainerPort> items) {
    if (this.ports == null) {this.ports = new ArrayList<ContainerPortBuilder>();}
    for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.ContainerPort... items) {
    for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(Collection<ContainerPort> items) {
    for (ContainerPort item : items) {ContainerPortBuilder builder = new ContainerPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<ContainerPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<ContainerPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      ContainerPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerPort> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public List<ContainerPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public ContainerPort buildPort(Integer index) {
    return this.ports.get(index).build();
  }
  public ContainerPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public ContainerPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public ContainerPort buildMatchingPort(Predicate<ContainerPortBuilder> predicate) {
    for (ContainerPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPort(Predicate<ContainerPortBuilder> predicate) {
    for (ContainerPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<ContainerPort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new ArrayList(); for (ContainerPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.ContainerPort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (ContainerPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(Integer containerPort,String hostIP,Integer hostPort,String name,String protocol) {
    return (A)addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
  }
  public EphemeralContainerFluent.PortsNested<A> addNewPort() {
    return new EphemeralContainerFluentImpl.PortsNestedImpl();
  }
  public EphemeralContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item) {
    return new EphemeralContainerFluentImpl.PortsNestedImpl(-1, item);
  }
  public EphemeralContainerFluent.PortsNested<A> setNewPortLike(Integer index,ContainerPort item) {
    return new EphemeralContainerFluentImpl.PortsNestedImpl(index, item);
  }
  public EphemeralContainerFluent.PortsNested<A> editPort(Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public EphemeralContainerFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public EphemeralContainerFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public EphemeralContainerFluent.PortsNested<A> editMatchingPort(Predicate<ContainerPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  
  /**
   * This method has been deprecated, please use method buildReadinessProbe instead.
   * @return The buildable object.
   */
  @Deprecated
  public Probe getReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public Probe buildReadinessProbe() {
    return this.readinessProbe!=null ?this.readinessProbe.build():null;
  }
  public A withReadinessProbe(Probe readinessProbe) {
    _visitables.get("readinessProbe").remove(this.readinessProbe);
    if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} else { this.readinessProbe = null; _visitables.get("readinessProbe").remove(this.readinessProbe); } return (A) this;
  }
  public Boolean hasReadinessProbe() {
    return this.readinessProbe != null;
  }
  public EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
    return new EphemeralContainerFluentImpl.ReadinessProbeNestedImpl();
  }
  public EphemeralContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
    return new EphemeralContainerFluentImpl.ReadinessProbeNestedImpl(item);
  }
  public EphemeralContainerFluent.ReadinessProbeNested<A> editReadinessProbe() {
    return withNewReadinessProbeLike(getReadinessProbe());
  }
  public EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
    return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
  }
  public EphemeralContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
    return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public EphemeralContainerFluent.ResourcesNested<A> withNewResources() {
    return new EphemeralContainerFluentImpl.ResourcesNestedImpl();
  }
  public EphemeralContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new EphemeralContainerFluentImpl.ResourcesNestedImpl(item);
  }
  public EphemeralContainerFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public EphemeralContainerFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public EphemeralContainerFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecurityContext instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecurityContext getSecurityContext() {
    return this.securityContext!=null ?this.securityContext.build():null;
  }
  public SecurityContext buildSecurityContext() {
    return this.securityContext!=null ?this.securityContext.build():null;
  }
  public A withSecurityContext(SecurityContext securityContext) {
    _visitables.get("securityContext").remove(this.securityContext);
    if (securityContext!=null){ this.securityContext= new SecurityContextBuilder(securityContext); _visitables.get("securityContext").add(this.securityContext);} else { this.securityContext = null; _visitables.get("securityContext").remove(this.securityContext); } return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContext() {
    return new EphemeralContainerFluentImpl.SecurityContextNestedImpl();
  }
  public EphemeralContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item) {
    return new EphemeralContainerFluentImpl.SecurityContextNestedImpl(item);
  }
  public EphemeralContainerFluent.SecurityContextNested<A> editSecurityContext() {
    return withNewSecurityContextLike(getSecurityContext());
  }
  public EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContext() {
    return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new SecurityContextBuilder().build());
  }
  public EphemeralContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item) {
    return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStartupProbe instead.
   * @return The buildable object.
   */
  @Deprecated
  public Probe getStartupProbe() {
    return this.startupProbe!=null ?this.startupProbe.build():null;
  }
  public Probe buildStartupProbe() {
    return this.startupProbe!=null ?this.startupProbe.build():null;
  }
  public A withStartupProbe(Probe startupProbe) {
    _visitables.get("startupProbe").remove(this.startupProbe);
    if (startupProbe!=null){ this.startupProbe= new ProbeBuilder(startupProbe); _visitables.get("startupProbe").add(this.startupProbe);} else { this.startupProbe = null; _visitables.get("startupProbe").remove(this.startupProbe); } return (A) this;
  }
  public Boolean hasStartupProbe() {
    return this.startupProbe != null;
  }
  public EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbe() {
    return new EphemeralContainerFluentImpl.StartupProbeNestedImpl();
  }
  public EphemeralContainerFluent.StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
    return new EphemeralContainerFluentImpl.StartupProbeNestedImpl(item);
  }
  public EphemeralContainerFluent.StartupProbeNested<A> editStartupProbe() {
    return withNewStartupProbeLike(getStartupProbe());
  }
  public EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbe() {
    return withNewStartupProbeLike(getStartupProbe() != null ? getStartupProbe(): new ProbeBuilder().build());
  }
  public EphemeralContainerFluent.StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
    return withNewStartupProbeLike(getStartupProbe() != null ? getStartupProbe(): item);
  }
  public Boolean getStdin() {
    return this.stdin;
  }
  public A withStdin(Boolean stdin) {
    this.stdin=stdin; return (A) this;
  }
  public Boolean hasStdin() {
    return this.stdin != null;
  }
  public Boolean getStdinOnce() {
    return this.stdinOnce;
  }
  public A withStdinOnce(Boolean stdinOnce) {
    this.stdinOnce=stdinOnce; return (A) this;
  }
  public Boolean hasStdinOnce() {
    return this.stdinOnce != null;
  }
  public String getTargetContainerName() {
    return this.targetContainerName;
  }
  public A withTargetContainerName(String targetContainerName) {
    this.targetContainerName=targetContainerName; return (A) this;
  }
  public Boolean hasTargetContainerName() {
    return this.targetContainerName != null;
  }
  public String getTerminationMessagePath() {
    return this.terminationMessagePath;
  }
  public A withTerminationMessagePath(String terminationMessagePath) {
    this.terminationMessagePath=terminationMessagePath; return (A) this;
  }
  public Boolean hasTerminationMessagePath() {
    return this.terminationMessagePath != null;
  }
  public String getTerminationMessagePolicy() {
    return this.terminationMessagePolicy;
  }
  public A withTerminationMessagePolicy(String terminationMessagePolicy) {
    this.terminationMessagePolicy=terminationMessagePolicy; return (A) this;
  }
  public Boolean hasTerminationMessagePolicy() {
    return this.terminationMessagePolicy != null;
  }
  public Boolean getTty() {
    return this.tty;
  }
  public A withTty(Boolean tty) {
    this.tty=tty; return (A) this;
  }
  public Boolean hasTty() {
    return this.tty != null;
  }
  public A addToVolumeDevices(Integer index,VolumeDevice item) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();}
    VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(index >= 0 ? index : _visitables.get("volumeDevices").size(), builder);this.volumeDevices.add(index >= 0 ? index : volumeDevices.size(), builder); return (A)this;
  }
  public A setToVolumeDevices(Integer index,VolumeDevice item) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();}
    VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
    if (index < 0 || index >= _visitables.get("volumeDevices").size()) { _visitables.get("volumeDevices").add(builder); } else { _visitables.get("volumeDevices").set(index, builder);}
    if (index < 0 || index >= volumeDevices.size()) { volumeDevices.add(builder); } else { volumeDevices.set(index, builder);}
     return (A)this;
  }
  public A addToVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();}
    for (VolumeDevice item : items) {VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(builder);this.volumeDevices.add(builder);} return (A)this;
  }
  public A addAllToVolumeDevices(Collection<VolumeDevice> items) {
    if (this.volumeDevices == null) {this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();}
    for (VolumeDevice item : items) {VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);_visitables.get("volumeDevices").add(builder);this.volumeDevices.add(builder);} return (A)this;
  }
  public A removeFromVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... items) {
    for (VolumeDevice item : items) {VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);_visitables.get("volumeDevices").remove(builder);if (this.volumeDevices != null) {this.volumeDevices.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumeDevices(Collection<VolumeDevice> items) {
    for (VolumeDevice item : items) {VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);_visitables.get("volumeDevices").remove(builder);if (this.volumeDevices != null) {this.volumeDevices.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumeDevices(Predicate<VolumeDeviceBuilder> predicate) {
    if (volumeDevices == null) return (A) this;
    final Iterator<VolumeDeviceBuilder> each = volumeDevices.iterator();
    final List visitables = _visitables.get("volumeDevices");
    while (each.hasNext()) {
      VolumeDeviceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumeDevices instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<VolumeDevice> getVolumeDevices() {
    return volumeDevices != null ? build(volumeDevices) : null;
  }
  public List<VolumeDevice> buildVolumeDevices() {
    return volumeDevices != null ? build(volumeDevices) : null;
  }
  public VolumeDevice buildVolumeDevice(Integer index) {
    return this.volumeDevices.get(index).build();
  }
  public VolumeDevice buildFirstVolumeDevice() {
    return this.volumeDevices.get(0).build();
  }
  public VolumeDevice buildLastVolumeDevice() {
    return this.volumeDevices.get(volumeDevices.size() - 1).build();
  }
  public VolumeDevice buildMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
    for (VolumeDeviceBuilder item: volumeDevices) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
    for (VolumeDeviceBuilder item: volumeDevices) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeDevices(List<VolumeDevice> volumeDevices) {
    if (this.volumeDevices != null) { _visitables.get("volumeDevices").removeAll(this.volumeDevices);}
    if (volumeDevices != null) {this.volumeDevices = new ArrayList(); for (VolumeDevice item : volumeDevices){this.addToVolumeDevices(item);}} else { this.volumeDevices = null;} return (A) this;
  }
  public A withVolumeDevices(io.fabric8.kubernetes.api.model.VolumeDevice... volumeDevices) {
    if (this.volumeDevices != null) {this.volumeDevices.clear();}
    if (volumeDevices != null) {for (VolumeDevice item :volumeDevices){ this.addToVolumeDevices(item);}} return (A) this;
  }
  public Boolean hasVolumeDevices() {
    return volumeDevices != null && !volumeDevices.isEmpty();
  }
  public A addNewVolumeDevice(String devicePath,String name) {
    return (A)addToVolumeDevices(new VolumeDevice(devicePath, name));
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice() {
    return new EphemeralContainerFluentImpl.VolumeDevicesNestedImpl();
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(VolumeDevice item) {
    return new EphemeralContainerFluentImpl.VolumeDevicesNestedImpl(-1, item);
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(Integer index,VolumeDevice item) {
    return new EphemeralContainerFluentImpl.VolumeDevicesNestedImpl(index, item);
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> editVolumeDevice(Integer index) {
    if (volumeDevices.size() <= index) throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
    return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice() {
    if (volumeDevices.size() == 0) throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
    return setNewVolumeDeviceLike(0, buildVolumeDevice(0));
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice() {
    int index = volumeDevices.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
    return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
  }
  public EphemeralContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeDevices.size();i++) { 
    if (predicate.test(volumeDevices.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
    return setNewVolumeDeviceLike(index, buildVolumeDevice(index));
  }
  public A addToVolumeMounts(Integer index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
  }
  public A setToVolumeMounts(Integer index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
    if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
     return (A)this;
  }
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
    if (volumeMounts == null) return (A) this;
    final Iterator<VolumeMountBuilder> each = volumeMounts.iterator();
    final List visitables = _visitables.get("volumeMounts");
    while (each.hasNext()) {
      VolumeMountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumeMounts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<VolumeMount> getVolumeMounts() {
    return volumeMounts != null ? build(volumeMounts) : null;
  }
  public List<VolumeMount> buildVolumeMounts() {
    return volumeMounts != null ? build(volumeMounts) : null;
  }
  public VolumeMount buildVolumeMount(Integer index) {
    return this.volumeMounts.get(index).build();
  }
  public VolumeMount buildFirstVolumeMount() {
    return this.volumeMounts.get(0).build();
  }
  public VolumeMount buildLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1).build();
  }
  public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
    if (volumeMounts != null) {this.volumeMounts = new ArrayList(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
  }
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear();}
    if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  public Boolean hasVolumeMounts() {
    return volumeMounts != null && !volumeMounts.isEmpty();
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMount() {
    return new EphemeralContainerFluentImpl.VolumeMountsNestedImpl();
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
    return new EphemeralContainerFluentImpl.VolumeMountsNestedImpl(-1, item);
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(Integer index,VolumeMount item) {
    return new EphemeralContainerFluentImpl.VolumeMountsNestedImpl(index, item);
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> editVolumeMount(Integer index) {
    if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> editFirstVolumeMount() {
    if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
    return setNewVolumeMountLike(0, buildVolumeMount(0));
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> editLastVolumeMount() {
    int index = volumeMounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  public EphemeralContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeMounts.size();i++) { 
    if (predicate.test(volumeMounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  public String getWorkingDir() {
    return this.workingDir;
  }
  public A withWorkingDir(String workingDir) {
    this.workingDir=workingDir; return (A) this;
  }
  public Boolean hasWorkingDir() {
    return this.workingDir != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EphemeralContainerFluentImpl that = (EphemeralContainerFluentImpl) o;
    if (args != null ? !args.equals(that.args) :that.args != null) return false;
    if (command != null ? !command.equals(that.command) :that.command != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (envFrom != null ? !envFrom.equals(that.envFrom) :that.envFrom != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (imagePullPolicy != null ? !imagePullPolicy.equals(that.imagePullPolicy) :that.imagePullPolicy != null) return false;
    if (lifecycle != null ? !lifecycle.equals(that.lifecycle) :that.lifecycle != null) return false;
    if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
    if (startupProbe != null ? !startupProbe.equals(that.startupProbe) :that.startupProbe != null) return false;
    if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
    if (stdinOnce != null ? !stdinOnce.equals(that.stdinOnce) :that.stdinOnce != null) return false;
    if (targetContainerName != null ? !targetContainerName.equals(that.targetContainerName) :that.targetContainerName != null) return false;
    if (terminationMessagePath != null ? !terminationMessagePath.equals(that.terminationMessagePath) :that.terminationMessagePath != null) return false;
    if (terminationMessagePolicy != null ? !terminationMessagePolicy.equals(that.terminationMessagePolicy) :that.terminationMessagePolicy != null) return false;
    if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
    if (volumeDevices != null ? !volumeDevices.equals(that.volumeDevices) :that.volumeDevices != null) return false;
    if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
    if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(args,  command,  env,  envFrom,  image,  imagePullPolicy,  lifecycle,  livenessProbe,  name,  ports,  readinessProbe,  resources,  securityContext,  startupProbe,  stdin,  stdinOnce,  targetContainerName,  terminationMessagePath,  terminationMessagePolicy,  tty,  volumeDevices,  volumeMounts,  workingDir,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (args != null && !args.isEmpty()) { sb.append("args:"); sb.append(args + ","); }
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (envFrom != null && !envFrom.isEmpty()) { sb.append("envFrom:"); sb.append(envFrom + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imagePullPolicy != null) { sb.append("imagePullPolicy:"); sb.append(imagePullPolicy + ","); }
    if (lifecycle != null) { sb.append("lifecycle:"); sb.append(lifecycle + ","); }
    if (livenessProbe != null) { sb.append("livenessProbe:"); sb.append(livenessProbe + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (readinessProbe != null) { sb.append("readinessProbe:"); sb.append(readinessProbe + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (startupProbe != null) { sb.append("startupProbe:"); sb.append(startupProbe + ","); }
    if (stdin != null) { sb.append("stdin:"); sb.append(stdin + ","); }
    if (stdinOnce != null) { sb.append("stdinOnce:"); sb.append(stdinOnce + ","); }
    if (targetContainerName != null) { sb.append("targetContainerName:"); sb.append(targetContainerName + ","); }
    if (terminationMessagePath != null) { sb.append("terminationMessagePath:"); sb.append(terminationMessagePath + ","); }
    if (terminationMessagePolicy != null) { sb.append("terminationMessagePolicy:"); sb.append(terminationMessagePolicy + ","); }
    if (tty != null) { sb.append("tty:"); sb.append(tty + ","); }
    if (volumeDevices != null && !volumeDevices.isEmpty()) { sb.append("volumeDevices:"); sb.append(volumeDevices + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (workingDir != null) { sb.append("workingDir:"); sb.append(workingDir + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withStdin() {
    return withStdin(true);
  }
  public A withStdinOnce() {
    return withStdinOnce(true);
  }
  public A withTty() {
    return withTty(true);
  }
  class EnvNestedImpl<N> extends EnvVarFluentImpl<EphemeralContainerFluent.EnvNested<N>> implements EphemeralContainerFluent.EnvNested<N>,Nested<N>{
    EnvNestedImpl(Integer index,EnvVar item) {
      this.index = index;
      this.builder = new EnvVarBuilder(this, item);
    }
    EnvNestedImpl() {
      this.index = -1;
      this.builder = new EnvVarBuilder(this);
    }
    EnvVarBuilder builder;
    Integer index;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.setToEnv(index,builder.build());
    }
    public N endEnv() {
      return and();
    }
    
  }
  class EnvFromNestedImpl<N> extends EnvFromSourceFluentImpl<EphemeralContainerFluent.EnvFromNested<N>> implements EphemeralContainerFluent.EnvFromNested<N>,Nested<N>{
    EnvFromNestedImpl(Integer index,EnvFromSource item) {
      this.index = index;
      this.builder = new EnvFromSourceBuilder(this, item);
    }
    EnvFromNestedImpl() {
      this.index = -1;
      this.builder = new EnvFromSourceBuilder(this);
    }
    EnvFromSourceBuilder builder;
    Integer index;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.setToEnvFrom(index,builder.build());
    }
    public N endEnvFrom() {
      return and();
    }
    
  }
  class LifecycleNestedImpl<N> extends LifecycleFluentImpl<EphemeralContainerFluent.LifecycleNested<N>> implements EphemeralContainerFluent.LifecycleNested<N>,Nested<N>{
    LifecycleNestedImpl(Lifecycle item) {
      this.builder = new LifecycleBuilder(this, item);
    }
    LifecycleNestedImpl() {
      this.builder = new LifecycleBuilder(this);
    }
    LifecycleBuilder builder;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.withLifecycle(builder.build());
    }
    public N endLifecycle() {
      return and();
    }
    
  }
  class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<EphemeralContainerFluent.LivenessProbeNested<N>> implements EphemeralContainerFluent.LivenessProbeNested<N>,Nested<N>{
    LivenessProbeNestedImpl(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    LivenessProbeNestedImpl() {
      this.builder = new ProbeBuilder(this);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe() {
      return and();
    }
    
  }
  class PortsNestedImpl<N> extends ContainerPortFluentImpl<EphemeralContainerFluent.PortsNested<N>> implements EphemeralContainerFluent.PortsNested<N>,Nested<N>{
    PortsNestedImpl(Integer index,ContainerPort item) {
      this.index = index;
      this.builder = new ContainerPortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new ContainerPortBuilder(this);
    }
    ContainerPortBuilder builder;
    Integer index;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<EphemeralContainerFluent.ReadinessProbeNested<N>> implements EphemeralContainerFluent.ReadinessProbeNested<N>,Nested<N>{
    ReadinessProbeNestedImpl(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    ReadinessProbeNestedImpl() {
      this.builder = new ProbeBuilder(this);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<EphemeralContainerFluent.ResourcesNested<N>> implements EphemeralContainerFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class SecurityContextNestedImpl<N> extends SecurityContextFluentImpl<EphemeralContainerFluent.SecurityContextNested<N>> implements EphemeralContainerFluent.SecurityContextNested<N>,Nested<N>{
    SecurityContextNestedImpl(SecurityContext item) {
      this.builder = new SecurityContextBuilder(this, item);
    }
    SecurityContextNestedImpl() {
      this.builder = new SecurityContextBuilder(this);
    }
    SecurityContextBuilder builder;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.withSecurityContext(builder.build());
    }
    public N endSecurityContext() {
      return and();
    }
    
  }
  class StartupProbeNestedImpl<N> extends ProbeFluentImpl<EphemeralContainerFluent.StartupProbeNested<N>> implements EphemeralContainerFluent.StartupProbeNested<N>,Nested<N>{
    StartupProbeNestedImpl(Probe item) {
      this.builder = new ProbeBuilder(this, item);
    }
    StartupProbeNestedImpl() {
      this.builder = new ProbeBuilder(this);
    }
    ProbeBuilder builder;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.withStartupProbe(builder.build());
    }
    public N endStartupProbe() {
      return and();
    }
    
  }
  class VolumeDevicesNestedImpl<N> extends VolumeDeviceFluentImpl<EphemeralContainerFluent.VolumeDevicesNested<N>> implements EphemeralContainerFluent.VolumeDevicesNested<N>,Nested<N>{
    VolumeDevicesNestedImpl(Integer index,VolumeDevice item) {
      this.index = index;
      this.builder = new VolumeDeviceBuilder(this, item);
    }
    VolumeDevicesNestedImpl() {
      this.index = -1;
      this.builder = new VolumeDeviceBuilder(this);
    }
    VolumeDeviceBuilder builder;
    Integer index;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.setToVolumeDevices(index,builder.build());
    }
    public N endVolumeDevice() {
      return and();
    }
    
  }
  class VolumeMountsNestedImpl<N> extends VolumeMountFluentImpl<EphemeralContainerFluent.VolumeMountsNested<N>> implements EphemeralContainerFluent.VolumeMountsNested<N>,Nested<N>{
    VolumeMountsNestedImpl(Integer index,VolumeMount item) {
      this.index = index;
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountsNestedImpl() {
      this.index = -1;
      this.builder = new VolumeMountBuilder(this);
    }
    VolumeMountBuilder builder;
    Integer index;
    public N and() {
      return (N) EphemeralContainerFluentImpl.this.setToVolumeMounts(index,builder.build());
    }
    public N endVolumeMount() {
      return and();
    }
    
  }
  
}