package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecEnvVarBuilder extends ExecEnvVarFluentImpl<ExecEnvVarBuilder> implements VisitableBuilder<ExecEnvVar,ExecEnvVarBuilder>{
  public ExecEnvVarBuilder() {
    this(false);
  }
  public ExecEnvVarBuilder(Boolean validationEnabled) {
    this(new ExecEnvVar(), validationEnabled);
  }
  public ExecEnvVarBuilder(ExecEnvVarFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecEnvVarBuilder(ExecEnvVarFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExecEnvVar(), validationEnabled);
  }
  public ExecEnvVarBuilder(ExecEnvVarFluent<?> fluent,ExecEnvVar instance) {
    this(fluent, instance, false);
  }
  public ExecEnvVarBuilder(ExecEnvVarFluent<?> fluent,ExecEnvVar instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExecEnvVarBuilder(ExecEnvVar instance) {
    this(instance,false);
  }
  public ExecEnvVarBuilder(ExecEnvVar instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ExecEnvVarFluent<?> fluent;
  Boolean validationEnabled;
  public ExecEnvVar build() {
    ExecEnvVar buildable = new ExecEnvVar(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}