package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NodeDaemonEndpointsFluentImpl<A extends NodeDaemonEndpointsFluent<A>> extends BaseFluent<A> implements NodeDaemonEndpointsFluent<A>{
  public NodeDaemonEndpointsFluentImpl() {
  }
  public NodeDaemonEndpointsFluentImpl(NodeDaemonEndpoints instance) {
    this.withKubeletEndpoint(instance.getKubeletEndpoint()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private DaemonEndpointBuilder kubeletEndpoint;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildKubeletEndpoint instead.
   * @return The buildable object.
   */
  @Deprecated
  public DaemonEndpoint getKubeletEndpoint() {
    return this.kubeletEndpoint!=null ?this.kubeletEndpoint.build():null;
  }
  public DaemonEndpoint buildKubeletEndpoint() {
    return this.kubeletEndpoint!=null ?this.kubeletEndpoint.build():null;
  }
  public A withKubeletEndpoint(DaemonEndpoint kubeletEndpoint) {
    _visitables.get("kubeletEndpoint").remove(this.kubeletEndpoint);
    if (kubeletEndpoint!=null){ this.kubeletEndpoint= new DaemonEndpointBuilder(kubeletEndpoint); _visitables.get("kubeletEndpoint").add(this.kubeletEndpoint);} else { this.kubeletEndpoint = null; _visitables.get("kubeletEndpoint").remove(this.kubeletEndpoint); } return (A) this;
  }
  public Boolean hasKubeletEndpoint() {
    return this.kubeletEndpoint != null;
  }
  public A withNewKubeletEndpoint(Integer port) {
    return (A)withKubeletEndpoint(new DaemonEndpoint(port));
  }
  public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpoint() {
    return new NodeDaemonEndpointsFluentImpl.KubeletEndpointNestedImpl();
  }
  public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> withNewKubeletEndpointLike(DaemonEndpoint item) {
    return new NodeDaemonEndpointsFluentImpl.KubeletEndpointNestedImpl(item);
  }
  public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editKubeletEndpoint() {
    return withNewKubeletEndpointLike(getKubeletEndpoint());
  }
  public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editOrNewKubeletEndpoint() {
    return withNewKubeletEndpointLike(getKubeletEndpoint() != null ? getKubeletEndpoint(): new DaemonEndpointBuilder().build());
  }
  public NodeDaemonEndpointsFluent.KubeletEndpointNested<A> editOrNewKubeletEndpointLike(DaemonEndpoint item) {
    return withNewKubeletEndpointLike(getKubeletEndpoint() != null ? getKubeletEndpoint(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NodeDaemonEndpointsFluentImpl that = (NodeDaemonEndpointsFluentImpl) o;
    if (kubeletEndpoint != null ? !kubeletEndpoint.equals(that.kubeletEndpoint) :that.kubeletEndpoint != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(kubeletEndpoint,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kubeletEndpoint != null) { sb.append("kubeletEndpoint:"); sb.append(kubeletEndpoint + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class KubeletEndpointNestedImpl<N> extends DaemonEndpointFluentImpl<NodeDaemonEndpointsFluent.KubeletEndpointNested<N>> implements NodeDaemonEndpointsFluent.KubeletEndpointNested<N>,Nested<N>{
    KubeletEndpointNestedImpl(DaemonEndpoint item) {
      this.builder = new DaemonEndpointBuilder(this, item);
    }
    KubeletEndpointNestedImpl() {
      this.builder = new DaemonEndpointBuilder(this);
    }
    DaemonEndpointBuilder builder;
    public N and() {
      return (N) NodeDaemonEndpointsFluentImpl.this.withKubeletEndpoint(builder.build());
    }
    public N endKubeletEndpoint() {
      return and();
    }
    
  }
  
}