package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface RBDVolumeSourceFluent<A extends RBDVolumeSourceFluent<A>> extends Fluent<A>{
  public String getFsType();
  public A withFsType(String fsType);
  public Boolean hasFsType();
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public String getKeyring();
  public A withKeyring(String keyring);
  public Boolean hasKeyring();
  public A addToMonitors(Integer index,String item);
  public A setToMonitors(Integer index,String item);
  public A addToMonitors(java.lang.String... items);
  public A addAllToMonitors(Collection<String> items);
  public A removeFromMonitors(java.lang.String... items);
  public A removeAllFromMonitors(Collection<String> items);
  public List<String> getMonitors();
  public String getMonitor(Integer index);
  public String getFirstMonitor();
  public String getLastMonitor();
  public String getMatchingMonitor(Predicate<String> predicate);
  public Boolean hasMatchingMonitor(Predicate<String> predicate);
  public A withMonitors(List<String> monitors);
  public A withMonitors(java.lang.String... monitors);
  public Boolean hasMonitors();
  public String getPool();
  public A withPool(String pool);
  public Boolean hasPool();
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef();
  public LocalObjectReference buildSecretRef();
  public A withSecretRef(LocalObjectReference secretRef);
  public Boolean hasSecretRef();
  public A withNewSecretRef(String name);
  public RBDVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
  public RBDVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item);
  public RBDVolumeSourceFluent.SecretRefNested<A> editSecretRef();
  public RBDVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
  public RBDVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item);
  public String getUser();
  public A withUser(String user);
  public Boolean hasUser();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withReadOnly();
  public interface SecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<RBDVolumeSourceFluent.SecretRefNested<N>>{
    public N and();
    public N endSecretRef();
    
  }
  
}