package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceStatusBuilder extends ServiceStatusFluentImpl<ServiceStatusBuilder> implements VisitableBuilder<ServiceStatus,ServiceStatusBuilder>{
  public ServiceStatusBuilder() {
    this(false);
  }
  public ServiceStatusBuilder(Boolean validationEnabled) {
    this(new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceStatus(), validationEnabled);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,ServiceStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceStatusBuilder(ServiceStatusFluent<?> fluent,ServiceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceStatusBuilder(ServiceStatus instance) {
    this(instance,false);
  }
  public ServiceStatusBuilder(ServiceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceStatus build() {
    ServiceStatus buildable = new ServiceStatus(fluent.getConditions(),fluent.getLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}