package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerListBuilder extends ReplicationControllerListFluentImpl<ReplicationControllerListBuilder> implements VisitableBuilder<ReplicationControllerList,ReplicationControllerListBuilder>{
  public ReplicationControllerListBuilder() {
    this(false);
  }
  public ReplicationControllerListBuilder(Boolean validationEnabled) {
    this(new ReplicationControllerList(), validationEnabled);
  }
  public ReplicationControllerListBuilder(ReplicationControllerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerListBuilder(ReplicationControllerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicationControllerList(), validationEnabled);
  }
  public ReplicationControllerListBuilder(ReplicationControllerListFluent<?> fluent,ReplicationControllerList instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerListBuilder(ReplicationControllerListFluent<?> fluent,ReplicationControllerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerListBuilder(ReplicationControllerList instance) {
    this(instance,false);
  }
  public ReplicationControllerListBuilder(ReplicationControllerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplicationControllerListFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicationControllerList build() {
    ReplicationControllerList buildable = new ReplicationControllerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}