package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerStatusBuilder extends ReplicationControllerStatusFluentImpl<ReplicationControllerStatusBuilder> implements VisitableBuilder<ReplicationControllerStatus,ReplicationControllerStatusBuilder>{
  public ReplicationControllerStatusBuilder() {
    this(false);
  }
  public ReplicationControllerStatusBuilder(Boolean validationEnabled) {
    this(new ReplicationControllerStatus(), validationEnabled);
  }
  public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicationControllerStatus(), validationEnabled);
  }
  public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerStatusBuilder(ReplicationControllerStatusFluent<?> fluent,ReplicationControllerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance) {
    this(instance,false);
  }
  public ReplicationControllerStatusBuilder(ReplicationControllerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ReplicationControllerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicationControllerStatus build() {
    ReplicationControllerStatus buildable = new ReplicationControllerStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}