package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface SecretVolumeSourceFluent<A extends SecretVolumeSourceFluent<A>> extends Fluent<A>{
  public Integer getDefaultMode();
  public A withDefaultMode(Integer defaultMode);
  public Boolean hasDefaultMode();
  public A addToItems(Integer index,KeyToPath item);
  public A setToItems(Integer index,KeyToPath item);
  public A addToItems(io.fabric8.kubernetes.api.model.KeyToPath... items);
  public A addAllToItems(Collection<KeyToPath> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.KeyToPath... items);
  public A removeAllFromItems(Collection<KeyToPath> items);
  public A removeMatchingFromItems(Predicate<KeyToPathBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<KeyToPath> getItems();
  public List<KeyToPath> buildItems();
  public KeyToPath buildItem(Integer index);
  public KeyToPath buildFirstItem();
  public KeyToPath buildLastItem();
  public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<KeyToPathBuilder> predicate);
  public A withItems(List<KeyToPath> items);
  public A withItems(io.fabric8.kubernetes.api.model.KeyToPath... items);
  public Boolean hasItems();
  public A addNewItem(String key,Integer mode,String path);
  public SecretVolumeSourceFluent.ItemsNested<A> addNewItem();
  public SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item);
  public SecretVolumeSourceFluent.ItemsNested<A> setNewItemLike(Integer index,KeyToPath item);
  public SecretVolumeSourceFluent.ItemsNested<A> editItem(Integer index);
  public SecretVolumeSourceFluent.ItemsNested<A> editFirstItem();
  public SecretVolumeSourceFluent.ItemsNested<A> editLastItem();
  public SecretVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate);
  public Boolean getOptional();
  public A withOptional(Boolean optional);
  public Boolean hasOptional();
  public String getSecretName();
  public A withSecretName(String secretName);
  public Boolean hasSecretName();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withOptional();
  public interface ItemsNested<N> extends Nested<N>,KeyToPathFluent<SecretVolumeSourceFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}