package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventSourceBuilder extends EventSourceFluentImpl<EventSourceBuilder> implements VisitableBuilder<EventSource,EventSourceBuilder>{
  public EventSourceBuilder() {
    this(false);
  }
  public EventSourceBuilder(Boolean validationEnabled) {
    this(new EventSource(), validationEnabled);
  }
  public EventSourceBuilder(EventSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public EventSourceBuilder(EventSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventSource(), validationEnabled);
  }
  public EventSourceBuilder(EventSourceFluent<?> fluent,EventSource instance) {
    this(fluent, instance, false);
  }
  public EventSourceBuilder(EventSourceFluent<?> fluent,EventSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withComponent(instance.getComponent());
      fluent.withHost(instance.getHost());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventSourceBuilder(EventSource instance) {
    this(instance,false);
  }
  public EventSourceBuilder(EventSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withComponent(instance.getComponent());
      this.withHost(instance.getHost());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventSourceFluent<?> fluent;
  Boolean validationEnabled;
  public EventSource build() {
    EventSource buildable = new EventSource(fluent.getComponent(),fluent.getHost());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}