package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ExecConfigFluent<A extends ExecConfigFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToArgs(int index,String item);
  public A setToArgs(int index,String item);
  public A addToArgs(java.lang.String... items);
  public A addAllToArgs(Collection<String> items);
  public A removeFromArgs(java.lang.String... items);
  public A removeAllFromArgs(Collection<String> items);
  public List<String> getArgs();
  public String getArg(int index);
  public String getFirstArg();
  public String getLastArg();
  public String getMatchingArg(Predicate<String> predicate);
  public Boolean hasMatchingArg(Predicate<String> predicate);
  public A withArgs(List<String> args);
  public A withArgs(java.lang.String... args);
  public Boolean hasArgs();
  public String getCommand();
  public A withCommand(String command);
  public Boolean hasCommand();
  public A addToEnv(int index,ExecEnvVar item);
  public A setToEnv(int index,ExecEnvVar item);
  public A addToEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... items);
  public A addAllToEnv(Collection<ExecEnvVar> items);
  public A removeFromEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... items);
  public A removeAllFromEnv(Collection<ExecEnvVar> items);
  public A removeMatchingFromEnv(Predicate<ExecEnvVarBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEnv instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ExecEnvVar> getEnv();
  public List<ExecEnvVar> buildEnv();
  public ExecEnvVar buildEnv(int index);
  public ExecEnvVar buildFirstEnv();
  public ExecEnvVar buildLastEnv();
  public ExecEnvVar buildMatchingEnv(Predicate<ExecEnvVarBuilder> predicate);
  public Boolean hasMatchingEnv(Predicate<ExecEnvVarBuilder> predicate);
  public A withEnv(List<ExecEnvVar> env);
  public A withEnv(io.fabric8.kubernetes.api.model.ExecEnvVar... env);
  public Boolean hasEnv();
  public A addNewEnv(String name,String value);
  public ExecConfigFluent.EnvNested<A> addNewEnv();
  public ExecConfigFluent.EnvNested<A> addNewEnvLike(ExecEnvVar item);
  public ExecConfigFluent.EnvNested<A> setNewEnvLike(int index,ExecEnvVar item);
  public ExecConfigFluent.EnvNested<A> editEnv(int index);
  public ExecConfigFluent.EnvNested<A> editFirstEnv();
  public ExecConfigFluent.EnvNested<A> editLastEnv();
  public ExecConfigFluent.EnvNested<A> editMatchingEnv(Predicate<ExecEnvVarBuilder> predicate);
  public String getInstallHint();
  public A withInstallHint(String installHint);
  public Boolean hasInstallHint();
  public String getInteractiveMode();
  public A withInteractiveMode(String interactiveMode);
  public Boolean hasInteractiveMode();
  public Boolean getProvideClusterInfo();
  public A withProvideClusterInfo(Boolean provideClusterInfo);
  public Boolean hasProvideClusterInfo();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withProvideClusterInfo();
  public interface EnvNested<N> extends Nested<N>,ExecEnvVarFluent<ExecConfigFluent.EnvNested<N>>{
    public N and();
    public N endEnv();
    
  }
  
}