package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCEPersistentDiskVolumeSourceBuilder extends GCEPersistentDiskVolumeSourceFluentImpl<GCEPersistentDiskVolumeSourceBuilder> implements VisitableBuilder<GCEPersistentDiskVolumeSource,GCEPersistentDiskVolumeSourceBuilder>{
  public GCEPersistentDiskVolumeSourceBuilder() {
    this(false);
  }
  public GCEPersistentDiskVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GCEPersistentDiskVolumeSource(), validationEnabled);
  }
  public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCEPersistentDiskVolumeSource(), validationEnabled);
  }
  public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSourceFluent<?> fluent,GCEPersistentDiskVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSourceFluent<?> fluent,GCEPersistentDiskVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPartition(instance.getPartition());
      fluent.withPdName(instance.getPdName());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSource instance) {
    this(instance,false);
  }
  public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPartition(instance.getPartition());
      this.withPdName(instance.getPdName());
      this.withReadOnly(instance.getReadOnly());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCEPersistentDiskVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GCEPersistentDiskVolumeSource build() {
    GCEPersistentDiskVolumeSource buildable = new GCEPersistentDiskVolumeSource(fluent.getFsType(),fluent.getPartition(),fluent.getPdName(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}