package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LabelSelectorBuilder extends LabelSelectorFluentImpl<LabelSelectorBuilder> implements VisitableBuilder<LabelSelector,LabelSelectorBuilder>{
  public LabelSelectorBuilder() {
    this(false);
  }
  public LabelSelectorBuilder(Boolean validationEnabled) {
    this(new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LabelSelector(), validationEnabled);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent,LabelSelector instance) {
    this(fluent, instance, false);
  }
  public LabelSelectorBuilder(LabelSelectorFluent<?> fluent,LabelSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchLabels(instance.getMatchLabels());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LabelSelectorBuilder(LabelSelector instance) {
    this(instance,false);
  }
  public LabelSelectorBuilder(LabelSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchLabels(instance.getMatchLabels());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LabelSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public LabelSelector build() {
    LabelSelector buildable = new LabelSelector(fluent.getMatchExpressions(),fluent.getMatchLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}