package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedExtensionBuilder extends NamedExtensionFluentImpl<NamedExtensionBuilder> implements VisitableBuilder<NamedExtension,NamedExtensionBuilder>{
  public NamedExtensionBuilder() {
    this(false);
  }
  public NamedExtensionBuilder(Boolean validationEnabled) {
    this(new NamedExtension(), validationEnabled);
  }
  public NamedExtensionBuilder(NamedExtensionFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedExtensionBuilder(NamedExtensionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedExtension(), validationEnabled);
  }
  public NamedExtensionBuilder(NamedExtensionFluent<?> fluent,NamedExtension instance) {
    this(fluent, instance, false);
  }
  public NamedExtensionBuilder(NamedExtensionFluent<?> fluent,NamedExtension instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withExtension(instance.getExtension());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedExtensionBuilder(NamedExtension instance) {
    this(instance,false);
  }
  public NamedExtensionBuilder(NamedExtension instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withExtension(instance.getExtension());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedExtensionFluent<?> fluent;
  Boolean validationEnabled;
  public NamedExtension build() {
    NamedExtension buildable = new NamedExtension(fluent.getExtension(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}