package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeDaemonEndpointsBuilder extends NodeDaemonEndpointsFluentImpl<NodeDaemonEndpointsBuilder> implements VisitableBuilder<NodeDaemonEndpoints,NodeDaemonEndpointsBuilder>{
  public NodeDaemonEndpointsBuilder() {
    this(false);
  }
  public NodeDaemonEndpointsBuilder(Boolean validationEnabled) {
    this(new NodeDaemonEndpoints(), validationEnabled);
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeDaemonEndpoints(), validationEnabled);
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent,NodeDaemonEndpoints instance) {
    this(fluent, instance, false);
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpointsFluent<?> fluent,NodeDaemonEndpoints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKubeletEndpoint(instance.getKubeletEndpoint());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpoints instance) {
    this(instance,false);
  }
  public NodeDaemonEndpointsBuilder(NodeDaemonEndpoints instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKubeletEndpoint(instance.getKubeletEndpoint());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeDaemonEndpointsFluent<?> fluent;
  Boolean validationEnabled;
  public NodeDaemonEndpoints build() {
    NodeDaemonEndpoints buildable = new NodeDaemonEndpoints(fluent.getKubeletEndpoint());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}